/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.utility.log;

/**
 * Generic contract for logging.
 * <p>
 * Lots of framework uses complicated logging or
 * logging framework. Wee think that logging must be easy
 * therefore we use current JDK Logger and logs exceptions
 * over it.
 * </p>
 * <p>
 * If you would like to use any other logging framework, set system property
 * then we use it.
 * </p>
 * @author gurkanerdogdu
 * @version $Rev$ $Date$ 
 */
public interface ILogger
{   
    /**System property for logging usage.*/
    public static final String LOGGING_SYSTEM_PROPERTY = "org.defne.utility.log.ILogger";
    
    public boolean isFatalEnabled();
    public boolean isErrorEnabled();
    public boolean isWarnEnabled();
    public boolean isInfoEnabled();
    public boolean isDebugEnabled();
    public boolean isTraceEnabled();
    public void fatal(String message);
    public void fatal(String message, Throwable error);
    public void fatal(Throwable error);
    public void error(String message);
    public void error(Throwable error);
    public void error(String message, Throwable error);
    public void warn(String message);
    public void warn(String message, Throwable error);
    public void warn(Throwable error);
    public void info(String message);
    public void info(String message, Throwable error);
    public void info(Throwable error);
    public void debug(String message);
    public void debug(String message, Throwable error);
    public void debug(Throwable error);
    public void trace(String message);
    public void trace(String message, Throwable error);
    public void trace(Throwable error);

}
