/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.utility.log;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

import org.defne.utility.exception.DefneException;
import org.defne.utility.reflection.SecurityActions;

/**
 * Provider class for the {@link ILogger}
 * instances.
 * 
 * @version $Rev$ $Date$
 *
 */
public final class LoggerProvider
{
    /**
     * Private constructor.
     */
    private LoggerProvider()
    {
        throw new UnsupportedOperationException();
    }
    
    /**
     * Gets the logger for the given class.
     * @param forClass logger owner
     * @return the logger
     */
    @SuppressWarnings("unchecked")
    public static ILogger getLogProvider(Class<?> forClass)
    {
        //Try from System Propery
        String loggerClass = SecurityActions.UTIL.getSecurityActions().getAndSetSystemProperty(ILogger.LOGGING_SYSTEM_PROPERTY, 
                "org.defne.utility.log.JDKLogger");
        
        Class<?> clazz = SecurityActions.UTIL.getSecurityActions().getClass(loggerClass);
        if(!ILogger.class.isAssignableFrom(clazz))
        {
            throw new DefneException("Given logger class implementation is not an instanceof ILogger");
        }
        
        Class<ILogger> convertedClass = (Class<ILogger>)clazz;
        List<Class<?>> argumentTypes = new ArrayList<Class<?>>();
        argumentTypes.add(Class.class);
        
        Constructor<?> constructor = SecurityActions.UTIL.getSecurityActions().getConstructor(convertedClass, argumentTypes);
        ILogger logger = (ILogger)SecurityActions.UTIL.getSecurityActions().callConstructor(constructor, new Object[]{forClass});
        
        return logger;
    }
}
