/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.utility.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Provides localized message.
 * 
 * @author gurkanerdogdu
 * @version $Rev$ $Date$
 */
public final class Localization
{

    /** Resource bundle */
    private ResourceBundle resourceBundle = null;

    /** Configuration is set */
    private AtomicBoolean isSet = new AtomicBoolean(false);

    /** Base name of the resource bundle */
    private final String baseName;

    /** Current locale */
    private final Locale locale;

    /** Class loader */
    private final ClassLoader classLoader;

    /**
     * Creates a new instance.
     * 
     * @param baseName base name
     * @param locale locale
     * @param classloader class loader
     */
    public Localization(String baseName, Locale locale, final ClassLoader classloader)
    {
        this.baseName = baseName;
        this.locale = locale;
        this.classLoader = classloader;
    }

    /**
     * Gets formatted message.
     * 
     * @param key message key
     * @param args format arguments
     * @return the formatted messsage
     */
    public String getMessage(String key, Object[] args)
    {
        init();
        String message = this.resourceBundle.getString(key);
        if (message == null || message.equals(""))
        {
            message = key;
        }
        else
        {
            message = MessageFormat.format(message, args);
        }
        return message;
    }

    /**
     * Initialize the bundle.
     */
    private void init()
    {
        if (isSet.compareAndSet(false, true))
        {
            resourceBundle = ResourceBundle.getBundle(this.baseName, this.locale, this.classLoader);
        }
    }
}
