/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility;

import java.lang.reflect.InvocationTargetException;
import org.defne.utility.Assertions;
import org.defne.utility.exception.DefneException;

public final class Utility {
    private Utility() {
        throw new UnsupportedOperationException();
    }

    public static Throwable getTargetException(Exception exception) {
        Throwable target;
        Assertions.checkForNull(exception, "exception parameter is null");
        if (exception instanceof InvocationTargetException && (target = ((InvocationTargetException)exception).getTargetException()) != null) {
            return target;
        }
        return exception;
    }

    public static void throwsDefneException(Exception throwable) {
        Assertions.checkForNull(throwable, "throwable parameter is null");
        if (throwable instanceof DefneException) {
            throw (DefneException)throwable;
        }
        Throwable e = Utility.getTargetException(throwable);
        if (e instanceof DefneException) {
            throw (DefneException)e;
        }
        throw new DefneException(e);
    }

    public static String getSystemProperty(String propertyName) {
        Assertions.checkForNullParameter(propertyName, "propertyName");
        return System.getProperty(propertyName);
    }

    public static String getSystemProperty(String propertyName, String defaultValue) {
        Assertions.checkForNullParameter(propertyName, "propertyName");
        return System.getProperty(propertyName, defaultValue);
    }

    public static String getAndSetSystemProperty(String propertyName, String defaultValue) {
        Assertions.checkForNullParameter(propertyName, "propertyName");
        String value = Utility.getSystemProperty(propertyName);
        if (value == null) {
            System.setProperty(propertyName, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static String getExceptionMessage(DefneException e) {
        StringBuilder buffer = new StringBuilder("");
        if (e.getMessage() != null) {
            buffer.append(e.getMessage());
        }
        Throwable temp = e;
        Throwable cause = null;
        while ((cause = temp.getCause()) != null) {
            buffer.append(":");
            buffer.append(cause.getMessage());
            temp = cause;
        }
        return buffer.toString();
    }
}

