/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility.factories;

import java.util.HashMap;
import java.util.Map;
import org.defne.utility.Assertions;
import org.defne.utility.exception.DefneException;
import org.defne.utility.reflection.ReflectionUtils;

public final class SingletonProvider {
    public static final String SERVICE_SCANNER_CLASS = "org.defne.service.annotation.ServiceScanner";
    public static final String DEFAULT_EMF_PROVIDER_CLASS = "org.defne.jpa.impl.DefaultEmfProvider";
    private static Map<ClassLoader, Map<String, Object>> singletonMap = new HashMap<ClassLoader, Map<String, Object>>();

    private SingletonProvider() {
    }

    public static Object getSingletonInstance(String singletonName) {
        return SingletonProvider.getSingletonInstance(singletonName, ReflectionUtils.getThreadClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSingletonInstance(String singletonName, ClassLoader classLoader) {
        Object object = null;
        Map<ClassLoader, Map<String, Object>> map = singletonMap;
        synchronized (map) {
            Map<String, Object> managerMap = singletonMap.get(classLoader);
            if (managerMap == null) {
                managerMap = new HashMap<String, Object>();
                singletonMap.put(classLoader, managerMap);
            }
            if ((object = managerMap.get(singletonName)) == null) {
                try {
                    Class<?> clazz = ReflectionUtils.getClassFromName(singletonName);
                    object = clazz.newInstance();
                    managerMap.put(singletonName, object);
                }
                catch (InstantiationException e) {
                    throw new DefneException("Unable to instantiate class : " + singletonName, e);
                }
                catch (IllegalAccessException e) {
                    throw new DefneException("Illegal access exception in creating instance with class : " + singletonName, e);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstances(ClassLoader classLoader) {
        Assertions.checkForNull(classLoader, "classloader is null");
        Map<ClassLoader, Map<String, Object>> map = singletonMap;
        synchronized (map) {
            singletonMap.remove(classLoader);
        }
    }
}

