/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.defne.utility.log.ILogger;

public class JDKLogger
implements ILogger {
    private final Logger logger;

    public JDKLogger(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz.getName());
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.logger.fine(message);
        }
    }

    @Override
    public void debug(String message, Throwable error) {
        if (this.isDebugEnabled()) {
            this.logger.log(Level.FINE, message, error);
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.logger.log(Level.SEVERE, message);
        }
    }

    @Override
    public void error(String message, Throwable error) {
        if (this.isErrorEnabled()) {
            this.logger.log(Level.SEVERE, message, error);
        }
    }

    @Override
    public void fatal(String message) {
        this.error(message);
    }

    @Override
    public void fatal(String message, Throwable error) {
        this.error(message, error);
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.logger.info(message);
        }
    }

    @Override
    public void info(String message, Throwable error) {
        if (this.isInfoEnabled()) {
            this.logger.log(Level.INFO, message, error);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.logger.log(Level.FINEST, message);
        }
    }

    @Override
    public void trace(String message, Throwable error) {
        if (this.isTraceEnabled()) {
            this.logger.log(Level.FINEST, message, error);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.logger.log(Level.WARNING, message);
        }
    }

    @Override
    public void warn(String message, Throwable error) {
        if (this.isWarnEnabled()) {
            this.logger.log(Level.WARNING, message);
        }
    }

    @Override
    public void error(Throwable error) {
        this.logger.log(Level.SEVERE, "Exception without getting error message!", error);
    }

    @Override
    public void debug(Throwable error) {
        this.logger.log(Level.FINE, "Exception without getting error message!", error);
    }

    @Override
    public void fatal(Throwable error) {
        this.logger.log(Level.SEVERE, "Exception without getting error message!", error);
    }

    @Override
    public void info(Throwable error) {
        this.logger.log(Level.INFO, "Exception without getting error message!", error);
    }

    @Override
    public void trace(Throwable error) {
        this.logger.log(Level.FINEST, "Exception without getting error message!", error);
    }

    @Override
    public void warn(Throwable error) {
        this.logger.log(Level.WARNING, "Exception without getting error message!", error);
    }
}

