/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility.log;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.reflection.SecurityActions;

public final class LoggerProvider {
    private LoggerProvider() {
        throw new UnsupportedOperationException();
    }

    public static ILogger getLogProvider(Class<?> forClass) {
        String loggerClass = SecurityActions.UTIL.getSecurityActions().getAndSetSystemProperty("org.defne.utility.log.ILogger", "org.defne.utility.log.JDKLogger");
        Class<?> clazz = SecurityActions.UTIL.getSecurityActions().getClass(loggerClass);
        if (!ILogger.class.isAssignableFrom(clazz)) {
            throw new DefneException("Given logger class implementation is not an instanceof ILogger");
        }
        Class<?> convertedClass = clazz;
        ArrayList argumentTypes = new ArrayList();
        argumentTypes.add(Class.class);
        Constructor<?> constructor = SecurityActions.UTIL.getSecurityActions().getConstructor(convertedClass, argumentTypes);
        ILogger logger = (ILogger)SecurityActions.UTIL.getSecurityActions().callConstructor(constructor, new Object[]{forClass});
        return logger;
    }
}

