/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.List;
import org.defne.utility.Assertions;
import org.defne.utility.Utility;
import org.defne.utility.exception.DefneException;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

public final class ReflectionUtils {
    public static final Class<?>[] EMPTY = new Class[0];
    private static final ILogger logger = LoggerProvider.getLogProvider(ReflectionUtils.class);

    private ReflectionUtils() {
        throw new UnsupportedOperationException();
    }

    public static ClassLoader getThreadClassLoader() {
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
        return loader;
    }

    public static <T> Object getNewObject(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            String error = "InstantiationException exception is thrown while creating instance of class : " + clazz;
            logger.error(error, e);
            throw new DefneException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "IllegalAccessException exception is thrown while creating instance of class : " + clazz;
            throw new DefneException(error, e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, List<Class<?>> arguments) {
        Assertions.checkForNullParameter(clazz, "clazz");
        Assertions.checkForNullParameter(arguments, "arguments");
        Constructor<T> constr = null;
        try {
            constr = clazz.getDeclaredConstructor(arguments.toArray(EMPTY));
        }
        catch (SecurityException e) {
            String error = "SecurityException exception is thrown by getting constructor";
            logger.error(error, e);
            throw new DefneException(error, e);
        }
        catch (NoSuchMethodException e) {
            String error = "NoSuchMethodException exception is thrown by getting constructor";
            logger.error(error, e);
            throw new DefneException(error, e);
        }
        return constr;
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static Object invokeMethod(Object instance, Method method, Object[] arguments) {
        Object result = null;
        try {
            result = method.invoke(instance, arguments);
        }
        catch (IllegalArgumentException e) {
            String error = "IllegalArgument exception is thrown by calling method " + method + " on instance " + instance + " with arguments " + arguments;
            logger.error(error, e);
            throw new DefneException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "IllegalAccessException exception is thrown by calling method " + method + " on instance " + instance + " with arguments " + arguments;
            logger.error(error, e);
            throw new DefneException(error, e);
        }
        catch (InvocationTargetException e) {
            String error = "InvocationTargetException exception is thrown by calling method " + method + " on instance " + instance + " with arguments " + arguments;
            Throwable e1 = Utility.getTargetException(e);
            logger.error(error, e1);
            throw new DefneException(error, e1);
        }
        return result;
    }

    public static Class<?> getClassFromName(String className) {
        Assertions.checkForNull(className, "className is null");
        ClassLoader loader = ReflectionUtils.getThreadClassLoader();
        try {
            if (loader == null) {
                return Class.forName(className);
            }
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            String error = "Class not found exception is thrown while getting class : " + className;
            logger.error(error, e);
            throw new DefneException(error, e);
        }
    }

    public static Object callConstructor(Constructor<?> constructor, Object[] arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalArgumentException e) {
            String error = "IllegalArgumentException exception is thrown by calling constructor " + constructor + " with arguments " + arguments;
            Throwable e1 = Utility.getTargetException(e);
            logger.error(error, e1);
            throw new DefneException(error, e1);
        }
        catch (InstantiationException e) {
            String error = "InstantiationException exception is thrown by calling constructor " + constructor + " with arguments " + arguments;
            Throwable e1 = Utility.getTargetException(e);
            logger.error(error, e1);
            throw new DefneException(error, e1);
        }
        catch (IllegalAccessException e) {
            String error = "IllegalAccessException exception is thrown by calling constructor " + constructor + " with arguments " + arguments;
            Throwable e1 = Utility.getTargetException(e);
            logger.error(error, e1);
            throw new DefneException(error, e1);
        }
        catch (InvocationTargetException e) {
            String error = "InvocationTargetException exception is thrown by calling constructor " + constructor + " with arguments " + arguments;
            Throwable e1 = Utility.getTargetException(e);
            logger.error(error, e1);
            throw new DefneException(error, e1);
        }
    }

    public static void throwDefneExceptionFromPrivilege(PrivilegedActionException e) {
        DefneException exception = null;
        exception = e.getCause() instanceof DefneException ? (DefneException)e.getCause() : new DefneException(e.getCause());
        throw exception;
    }

    public static void main(String[] args) {
        System.out.println(EMPTY);
    }
}

