/*
 * Decompiled with CFR 0.152.
 */
package org.defne.utility.reflection;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.defne.utility.Utility;
import org.defne.utility.reflection.ReflectionUtils;

public interface SecurityActions {
    public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

        @Override
        public Class<?> getClass(String className) {
            return ReflectionUtils.getClassFromName(className);
        }

        @Override
        public Constructor<?> getConstructor(Class<?> clazz, List<Class<?>> arguments) {
            return ReflectionUtils.getConstructor(clazz, arguments);
        }

        @Override
        public Object newInstance(Class<?> clazz) {
            return ReflectionUtils.getNewObject(clazz);
        }

        @Override
        public Object callConstructor(Constructor<?> constructor, Object[] arguments) {
            return ReflectionUtils.callConstructor(constructor, arguments);
        }

        @Override
        public String getSystemProperty(String systemProperty) {
            return Utility.getSystemProperty(systemProperty);
        }

        @Override
        public String getSystemProperty(String systemProperty, String defaultValue) {
            return Utility.getSystemProperty(systemProperty, defaultValue);
        }

        @Override
        public String getAndSetSystemProperty(String systemProperty, String value) {
            return Utility.getAndSetSystemProperty(systemProperty, value);
        }
    };
    public static final SecurityActions PRIVILEGED = new SecurityActions(){

        @Override
        public Class<?> getClass(final String className) {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return ReflectionUtils.getClassFromName(className);
                }
            };
            try {
                return (Class)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public Constructor<?> getConstructor(final Class<?> clazz, final List<Class<?>> arguments) {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws Exception {
                    return ReflectionUtils.getConstructor(clazz, arguments);
                }
            };
            try {
                return (Constructor)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public Object newInstance(final Class<?> clazz) {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return ReflectionUtils.getNewObject(clazz);
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public Object callConstructor(final Constructor<?> constructor, final Object[] arguments) {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return ReflectionUtils.callConstructor(constructor, arguments);
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public String getSystemProperty(final String systemProperty) {
            PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return System.getProperty(systemProperty);
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public String getSystemProperty(final String systemProperty, final String defaultValue) {
            PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return System.getProperty(systemProperty, defaultValue);
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }

        @Override
        public String getAndSetSystemProperty(final String systemProperty, final String value) {
            PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return Utility.getAndSetSystemProperty(systemProperty, value);
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                ReflectionUtils.throwDefneExceptionFromPrivilege(e);
                return null;
            }
        }
    };

    public Constructor<?> getConstructor(Class<?> var1, List<Class<?>> var2);

    public Object newInstance(Class<?> var1);

    public Class<?> getClass(String var1);

    public Object callConstructor(Constructor<?> var1, Object[] var2);

    public String getSystemProperty(String var1);

    public String getSystemProperty(String var1, String var2);

    public String getAndSetSystemProperty(String var1, String var2);

    public static class UTIL {
        public static SecurityActions getSecurityActions() {
            return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
        }
    }
}

