/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.queue.jedis;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.resps.KeyedZSetElement;

public class JedisKeyedBlockingQueue {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_LONG_FOR_INTS, true).registerModule((Module)new JavaTimeModule());
    private final JedisPool jedisPool;

    public JedisKeyedBlockingQueue(String url, String password, int maxIdle, int maxTotal) throws URISyntaxException {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        URI uri = new URI(url);
        this.jedisPool = password == null ? new JedisPool(poolConfig, uri) : new JedisPool(poolConfig, uri.getHost(), uri.getPort(), 2000, password);
    }

    public void put(String key, Object object) throws JsonProcessingException {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.put(jedis, key, object);
        }
    }

    public void drop(List<String> keys) {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.drop(jedis, keys);
        }
    }

    private void drop(Jedis jedis, List<String> keys) {
        keys.forEach(arg_0 -> ((Jedis)jedis).del(arg_0));
    }

    private void put(Jedis jedis, String key, Object value) throws JsonProcessingException {
        jedis.zadd(key, (double)Instant.now().toEpochMilli(), OBJECT_MAPPER.writeValueAsString(value), ZAddParams.zAddParams().nx());
    }

    public void put(List<Pair<String, Object>> items) throws JsonProcessingException, JedisConnectionException {
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (Pair<String, Object> item : items) {
                p.zadd((String)item.getKey(), (double)Instant.now().toEpochMilli(), OBJECT_MAPPER.writeValueAsString(item.getValue()), ZAddParams.zAddParams().nx());
            }
            p.sync();
        }
    }

    public <T> T take(String key, Class<T> objectClass) throws JsonProcessingException, JedisConnectionException {
        try (Jedis jedis = this.jedisPool.getResource();){
            KeyedZSetElement keyedZSetElement = jedis.bzpopmin(0.0, new String[]{key});
            Object object = OBJECT_MAPPER.readValue(keyedZSetElement.getElement(), objectClass);
            return (T)object;
        }
    }
}

