/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.splitter;

import org.springframework.util.unit.DataSize;

public class SplitterParams {
    private String commentChars;
    private boolean includeHeaders;
    private int maxRows;
    private long maxSize;

    public SplitterParams(String commentChars, boolean includeHeaders, int maxRows, long maxSize) {
        this.commentChars = commentChars;
        this.includeHeaders = includeHeaders;
        this.setMaxRows(maxRows);
        this.setMaxSize(maxSize);
    }

    public void setMaxRows(int maxRows) {
        if (maxRows < 1) {
            throw new IllegalArgumentException("The max rows must be one or more");
        }
        this.maxRows = maxRows;
    }

    public void setMaxSize(long maxSize) {
        if (maxSize < 1L) {
            throw new IllegalArgumentException("The max size must be one or more");
        }
        this.maxSize = maxSize;
    }

    private static boolean $default$includeHeaders() {
        return false;
    }

    private static int $default$maxRows() {
        return Integer.MAX_VALUE;
    }

    private static long $default$maxSize() {
        return DataSize.ofMegabytes((long)500L).toBytes();
    }

    public static SplitterParamsBuilder builder() {
        return new SplitterParamsBuilder();
    }

    public String getCommentChars() {
        return this.commentChars;
    }

    public boolean isIncludeHeaders() {
        return this.includeHeaders;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setCommentChars(String commentChars) {
        this.commentChars = commentChars;
    }

    public void setIncludeHeaders(boolean includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitterParams)) {
            return false;
        }
        SplitterParams other = (SplitterParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeHeaders() != other.isIncludeHeaders()) {
            return false;
        }
        if (this.getMaxRows() != other.getMaxRows()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        String this$commentChars = this.getCommentChars();
        String other$commentChars = other.getCommentChars();
        return !(this$commentChars == null ? other$commentChars != null : !this$commentChars.equals(other$commentChars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitterParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeHeaders() ? 79 : 97);
        result = result * 59 + this.getMaxRows();
        long $maxSize = this.getMaxSize();
        result = result * 59 + (int)($maxSize >>> 32 ^ $maxSize);
        String $commentChars = this.getCommentChars();
        result = result * 59 + ($commentChars == null ? 43 : $commentChars.hashCode());
        return result;
    }

    public String toString() {
        return "SplitterParams(commentChars=" + this.getCommentChars() + ", includeHeaders=" + this.isIncludeHeaders() + ", maxRows=" + this.getMaxRows() + ", maxSize=" + this.getMaxSize() + ")";
    }

    public static class SplitterParamsBuilder {
        private String commentChars;
        private boolean includeHeaders$set;
        private boolean includeHeaders$value;
        private boolean maxRows$set;
        private int maxRows$value;
        private boolean maxSize$set;
        private long maxSize$value;

        SplitterParamsBuilder() {
        }

        public SplitterParamsBuilder commentChars(String commentChars) {
            this.commentChars = commentChars;
            return this;
        }

        public SplitterParamsBuilder includeHeaders(boolean includeHeaders) {
            this.includeHeaders$value = includeHeaders;
            this.includeHeaders$set = true;
            return this;
        }

        public SplitterParamsBuilder maxRows(int maxRows) {
            this.maxRows$value = maxRows;
            this.maxRows$set = true;
            return this;
        }

        public SplitterParamsBuilder maxSize(long maxSize) {
            this.maxSize$value = maxSize;
            this.maxSize$set = true;
            return this;
        }

        public SplitterParams build() {
            boolean includeHeaders$value = this.includeHeaders$value;
            if (!this.includeHeaders$set) {
                includeHeaders$value = SplitterParams.$default$includeHeaders();
            }
            int maxRows$value = this.maxRows$value;
            if (!this.maxRows$set) {
                maxRows$value = SplitterParams.$default$maxRows();
            }
            long maxSize$value = this.maxSize$value;
            if (!this.maxSize$set) {
                maxSize$value = SplitterParams.$default$maxSize();
            }
            return new SplitterParams(this.commentChars, includeHeaders$value, maxRows$value, maxSize$value);
        }

        public String toString() {
            return "SplitterParams.SplitterParamsBuilder(commentChars=" + this.commentChars + ", includeHeaders$value=" + this.includeHeaders$value + ", maxRows$value=" + this.maxRows$value + ", maxSize$value=" + this.maxSize$value + ")";
        }
    }
}

