/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.JoinActionConfiguration;
import org.deltafi.common.types.LoadActionConfiguration;
import org.deltafi.common.types.TransformActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class IngressFlowPlan
extends FlowPlan {
    private List<TransformActionConfiguration> transformActions;
    private LoadActionConfiguration loadAction;
    private JoinActionConfiguration joinAction;

    public IngressFlowPlan(String name, String description) {
        super(name, FlowType.INGRESS, description);
    }

    @PersistenceCreator
    @JsonCreator
    public IngressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.transformActions != null) {
            actionConfigurations.addAll(this.transformActions);
        }
        if (this.loadAction != null) {
            actionConfigurations.add(this.loadAction);
        }
        if (this.joinAction != null) {
            actionConfigurations.add(this.joinAction);
        }
        return actionConfigurations;
    }

    public List<TransformActionConfiguration> getTransformActions() {
        return this.transformActions;
    }

    public LoadActionConfiguration getLoadAction() {
        return this.loadAction;
    }

    public JoinActionConfiguration getJoinAction() {
        return this.joinAction;
    }

    public void setTransformActions(List<TransformActionConfiguration> transformActions) {
        this.transformActions = transformActions;
    }

    public void setLoadAction(LoadActionConfiguration loadAction) {
        this.loadAction = loadAction;
    }

    public void setJoinAction(JoinActionConfiguration joinAction) {
        this.joinAction = joinAction;
    }
}

