/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class Segment {
    private String uuid;
    private long offset;
    private long size;
    private String did;

    public Segment(String did) {
        this(UUID.randomUUID().toString(), did);
    }

    public Segment(Segment other) {
        this(other.getUuid(), other.getOffset(), other.getSize(), other.getDid());
    }

    public Segment(String uuid, String did) {
        this(uuid, 0L, -1L, did);
    }

    public String objectName() {
        return this.did.substring(0, 3) + "/" + this.did + "/" + this.uuid;
    }

    public static long calculateTotalSize(List<Segment> segments) {
        HashMap<String, List> segmentsByUuid = new HashMap<String, List>();
        for (Segment segment : segments) {
            segmentsByUuid.computeIfAbsent(segment.getUuid(), k -> new ArrayList()).add(segment);
        }
        long totalSize = 0L;
        for (List uuidSegments : segmentsByUuid.values()) {
            totalSize += Segment.calculateNonOverlappingSize(uuidSegments);
        }
        return totalSize;
    }

    private static long calculateNonOverlappingSize(List<Segment> uuidSegments) {
        if (uuidSegments.size() == 1) {
            return uuidSegments.get(0).getSize();
        }
        ArrayList<Segment> sortedSegments = new ArrayList<Segment>(uuidSegments);
        sortedSegments.sort(Comparator.comparingLong(Segment::getOffset));
        long totalSize = 0L;
        Segment mergedSegment = (Segment)sortedSegments.get(0);
        for (int i = 1; i < sortedSegments.size(); ++i) {
            Segment segment = (Segment)sortedSegments.get(i);
            if (segment.getOffset() >= mergedSegment.getOffset() + mergedSegment.getSize()) {
                totalSize += mergedSegment.getSize();
                mergedSegment = segment;
                continue;
            }
            long endPosition = Math.max(mergedSegment.getOffset() + mergedSegment.getSize(), segment.getOffset() + segment.getSize());
            mergedSegment = new Segment(mergedSegment.getUuid(), mergedSegment.getOffset(), endPosition - mergedSegment.getOffset(), mergedSegment.getDid());
        }
        return totalSize += mergedSegment.getSize();
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public String getDid() {
        return this.did;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        return !(this$did == null ? other$did != null : !this$did.equals(other$did));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        return result;
    }

    public String toString() {
        return "Segment(uuid=" + this.getUuid() + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ", did=" + this.getDid() + ")";
    }

    public Segment() {
    }

    public Segment(String uuid, long offset, long size, String did) {
        this.uuid = uuid;
        this.offset = offset;
        this.size = size;
        this.did = did;
    }
}

