/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.splitter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.content.ContentStorageService;
import org.deltafi.common.content.Segment;
import org.deltafi.common.splitter.CountingReader;
import org.deltafi.common.splitter.SplitException;
import org.deltafi.common.splitter.SplitterParams;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.types.Content;

public class ContentSplitter {
    static final String SEGMENT_OVERFLOW = "The segment will not fit within the max size limit";
    private final ContentStorageService contentStorageService;

    public ContentSplitter(ContentStorageService contentStorageService) {
        this.contentStorageService = contentStorageService;
    }

    public List<ContentReference> splitContent(Content content, SplitterParams splitterParams) {
        List<ContentReference> list;
        block9: {
            ContentReference contentReference = content.getContentReference();
            if (contentReference == null || contentReference.getSize() == 0L) {
                return List.of();
            }
            InputStream inputStream = this.contentStorageService.load(contentReference);
            try {
                list = this.splitInputStream(contentReference, inputStream, splitterParams);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ObjectStorageException e) {
                    throw new SplitException("Failed to split the contentReference", e);
                }
            }
            inputStream.close();
        }
        return list;
    }

    List<ContentReference> splitInputStream(ContentReference contentReference, InputStream contentInputStream, SplitterParams splitterParameters) {
        List<ContentReference> list;
        CountingReader countingReader = new CountingReader((Reader)new InputStreamReader(contentInputStream), splitterParameters.getMaxSize());
        try {
            list = this.splitData(contentReference, countingReader, splitterParameters);
        }
        catch (Throwable throwable) {
            try {
                try {
                    countingReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new SplitException("Failed to process the inputStream", exception);
            }
        }
        countingReader.close();
        return list;
    }

    List<ContentReference> splitData(ContentReference contentReference, CountingReader countingReader, SplitterParams splitterParams) throws IOException {
        List<Segment> subRefSegments;
        ArrayList<Segment> subRefWithHeaders;
        ArrayList<ContentReference> subReferences = new ArrayList<ContentReference>();
        List<Segment> headerSegments = this.findHeaderSegments(contentReference, countingReader, splitterParams);
        long maxRows = splitterParams.getMaxRows();
        long maxSize = splitterParams.getMaxSize();
        long headerSize = ContentReference.sumSegmentSizes(headerSegments);
        boolean firstSegment = true;
        long startOfChunk = 0L;
        long endOfChunk = 0L;
        long segmentRowCount = 0L;
        while (countingReader.countBytesInNextLine() != -1L) {
            long curSize = countingReader.getBytesRead() - startOfChunk;
            if (firstSegment) {
                curSize -= headerSize;
            }
            if (curSize > maxSize || segmentRowCount == maxRows) {
                if (endOfChunk == 0L) {
                    throw new SplitException(SEGMENT_OVERFLOW);
                }
                if (firstSegment) {
                    ContentReference subRef = contentReference.subreference(startOfChunk, endOfChunk - startOfChunk);
                    subReferences.add(subRef);
                    firstSegment = false;
                    startOfChunk += subRef.getSize();
                } else {
                    subRefWithHeaders = new ArrayList<Segment>(headerSegments);
                    subRefSegments = contentReference.subreferenceSegments(startOfChunk, endOfChunk - startOfChunk);
                    subRefWithHeaders.addAll(subRefSegments);
                    subReferences.add(new ContentReference(contentReference.getMediaType(), subRefWithHeaders));
                    startOfChunk += ContentReference.sumSegmentSizes(subRefSegments);
                }
                segmentRowCount = 0L;
            }
            endOfChunk = countingReader.getBytesRead();
            ++segmentRowCount;
        }
        long bytesLeftover = countingReader.getBytesRead() - startOfChunk;
        if (bytesLeftover > 0L) {
            subRefWithHeaders = new ArrayList<Segment>(headerSegments);
            subRefSegments = contentReference.subreferenceSegments(startOfChunk, bytesLeftover);
            subRefWithHeaders.addAll(subRefSegments);
            subReferences.add(new ContentReference(contentReference.getMediaType(), subRefWithHeaders));
        }
        return subReferences;
    }

    List<Segment> findHeaderSegments(ContentReference contentReference, CountingReader countingReader, SplitterParams splitterParams) throws IOException {
        if (!splitterParams.isIncludeHeaders()) {
            return List.of();
        }
        ArrayList<Segment> headerSegments = new ArrayList<Segment>(this.findHeaderSegment(contentReference, countingReader, splitterParams.getCommentChars()));
        long headerSize = ContentReference.sumSegmentSizes(headerSegments);
        long headerOffset = ContentReference.minOffset(headerSegments);
        if (headerOffset + headerSize > splitterParams.getMaxSize()) {
            throw new SplitException(SEGMENT_OVERFLOW);
        }
        splitterParams.setMaxSize(splitterParams.getMaxSize() - headerSize);
        countingReader.setMaxLineSize(splitterParams.getMaxSize());
        return headerSegments;
    }

    List<Segment> findHeaderSegment(ContentReference contentReference, CountingReader countingReader, String commentChars) throws IOException {
        boolean hasComments = commentChars != null && !commentChars.isBlank();
        long offset = 0L;
        String maybeHeader = countingReader.readLine();
        while (maybeHeader != null) {
            if (!hasComments || !maybeHeader.startsWith(commentChars)) {
                return contentReference.subreferenceSegments(offset, countingReader.getBytesRead() - offset);
            }
            offset = countingReader.getBytesRead();
            maybeHeader = countingReader.readLine();
        }
        throw new SplitException("Unable to find the header line");
    }
}

