/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.deltafi.common.content.Segment;

public class ContentReference {
    private String mediaType;
    private List<Segment> segments;

    public ContentReference(String mediaType, Segment ... segments) {
        this.mediaType = mediaType;
        this.segments = Arrays.stream(segments).toList();
    }

    public ContentReference(String mediaType, List<Segment> segments, long ignored) {
        this.mediaType = mediaType;
        this.segments = Collections.unmodifiableList(segments);
    }

    public void setSize(long ignored) {
    }

    public long getSize() {
        return ContentReference.sumSegmentSizes(this.segments);
    }

    public ContentReference subreference(long offset, long size) {
        return new ContentReference(this.getMediaType(), this.subreferenceSegments(offset, size));
    }

    public List<Segment> subreferenceSegments(long offset, long size) {
        if (offset < 0L) {
            throw new IllegalArgumentException("subreference offset must be positive, got " + offset);
        }
        if (size < 0L) {
            throw new IllegalArgumentException("subreference size must be positive, got " + size);
        }
        if (size + offset > this.getSize()) {
            throw new IllegalArgumentException("Size + offset ( " + size + " + " + offset + ") exceeds total ContentReference size of " + this.getSize());
        }
        if (size == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        long offsetRemaining = offset;
        long sizeRemaining = size;
        for (Segment segment : this.segments) {
            Segment newSegment = new Segment(segment);
            if (offsetRemaining > 0L) {
                if (newSegment.getSize() < offsetRemaining) {
                    offsetRemaining -= newSegment.getSize();
                    continue;
                }
                newSegment.setOffset(newSegment.getOffset() + offsetRemaining);
                newSegment.setSize(newSegment.getSize() - offsetRemaining);
                offsetRemaining = 0L;
            }
            if (sizeRemaining < newSegment.getSize()) {
                newSegment.setSize(sizeRemaining);
            }
            newSegments.add(newSegment);
            if ((sizeRemaining -= newSegment.getSize()) != 0L) continue;
            break;
        }
        return newSegments;
    }

    public static long sumSegmentSizes(List<Segment> segments) {
        return segments != null ? segments.stream().mapToLong(Segment::getSize).sum() : 0L;
    }

    public static long minOffset(List<Segment> segments) {
        return segments != null ? segments.stream().mapToLong(Segment::getOffset).min().orElse(0L) : 0L;
    }

    public ContentReference(String mediaType, List<Segment> segments) {
        this.mediaType = mediaType;
        this.segments = segments;
    }

    public ContentReference() {
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentReference)) {
            return false;
        }
        ContentReference other = (ContentReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        List<Segment> this$segments = this.getSegments();
        List<Segment> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        List<Segment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    public String toString() {
        return "ContentReference(mediaType=" + this.getMediaType() + ", segments=" + this.getSegments() + ")";
    }
}

