/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class AutoDestructTempFile
implements AutoCloseable {
    private final Path file;

    public AutoDestructTempFile() throws IOException {
        this(null, null);
    }

    public AutoDestructTempFile(String prefix, String postfix) throws IOException {
        this.file = Files.createTempFile(prefix, postfix, new FileAttribute[0]);
    }

    public AutoDestructTempFile(InputStream in, String prefix, String postfix) throws IOException {
        this(prefix, postfix);
        Files.copy(in, this.file, StandardCopyOption.REPLACE_EXISTING);
    }

    public AutoDestructTempFile(InputStream in) throws IOException {
        this(in, null, null);
    }

    public Path getPath() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        Files.delete(this.file);
    }
}

