/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;

public class SourceInfo {
    private String filename;
    private String flow;
    private Map<String, String> metadata;

    @JsonIgnore
    public boolean containsKey(String key) {
        return this.metadata.containsKey(key);
    }

    @JsonIgnore
    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    @JsonIgnore
    public String getMetadata(String key, String defaultValue) {
        return this.metadata.getOrDefault(key, defaultValue);
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public void addMetadata(Map<String, String> map) {
        if (map != null) {
            this.metadata.putAll(map);
        }
    }

    public void removeMetadata(String key) {
        this.metadata.remove(key);
    }

    private static Map<String, String> $default$metadata() {
        return new HashMap<String, String>();
    }

    public static SourceInfoBuilder builder() {
        return new SourceInfoBuilder();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFlow() {
        return this.flow;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceInfo)) {
            return false;
        }
        SourceInfo other = (SourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "SourceInfo(filename=" + this.getFilename() + ", flow=" + this.getFlow() + ", metadata=" + this.getMetadata() + ")";
    }

    public SourceInfo() {
        this.metadata = SourceInfo.$default$metadata();
    }

    public SourceInfo(String filename, String flow, Map<String, String> metadata) {
        this.filename = filename;
        this.flow = flow;
        this.metadata = metadata;
    }

    public static class SourceInfoBuilder {
        private String filename;
        private String flow;
        private boolean metadata$set;
        private Map<String, String> metadata$value;

        SourceInfoBuilder() {
        }

        public SourceInfoBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public SourceInfoBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public SourceInfoBuilder metadata(Map<String, String> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        public SourceInfo build() {
            Map<String, String> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = SourceInfo.$default$metadata();
            }
            return new SourceInfo(this.filename, this.flow, metadata$value);
        }

        public String toString() {
            return "SourceInfo.SourceInfoBuilder(filename=" + this.filename + ", flow=" + this.flow + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

