/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.deltafi.common.types.ActionContext;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.ActionInput;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.DeltaFiConfiguration;
import org.deltafi.common.types.DeltaFile;
import org.deltafi.common.types.DomainActionConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.EnrichActionConfiguration;
import org.deltafi.common.types.FormatActionConfiguration;
import org.deltafi.common.types.LoadActionConfiguration;
import org.deltafi.common.types.TransformActionConfiguration;
import org.deltafi.common.types.ValidateActionConfiguration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="__typename")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TransformActionConfiguration.class, name="TransformActionConfiguration"), @JsonSubTypes.Type(value=LoadActionConfiguration.class, name="LoadActionConfiguration"), @JsonSubTypes.Type(value=DomainActionConfiguration.class, name="DomainActionConfiguration"), @JsonSubTypes.Type(value=EnrichActionConfiguration.class, name="EnrichActionConfiguration"), @JsonSubTypes.Type(value=FormatActionConfiguration.class, name="FormatActionConfiguration"), @JsonSubTypes.Type(value=ValidateActionConfiguration.class, name="ValidateActionConfiguration"), @JsonSubTypes.Type(value=EgressActionConfiguration.class, name="EgressActionConfiguration")})
public abstract class ActionConfiguration
extends DeltaFiConfiguration {
    protected final ActionType actionType;
    protected final String type;
    protected Map<String, Object> parameters;

    public ActionConfiguration(String name, ActionType actionType, String type) {
        super(name);
        this.actionType = actionType;
        this.type = type;
    }

    static boolean equalOrAny(List<String> schemaList, List<String> configList) {
        List<Object> actual;
        List<Object> expected = Objects.isNull(schemaList) ? Collections.emptyList() : schemaList;
        List<Object> list = actual = Objects.isNull(configList) ? Collections.emptyList() : configList;
        if (expected.contains("any")) {
            return true;
        }
        if (expected.isEmpty()) {
            return actual.isEmpty();
        }
        return expected.stream().allMatch(item -> actual.stream().anyMatch(i -> i.equals(item)));
    }

    public ActionInput buildActionInput(DeltaFile deltaFile, String systemName, String egressFlow, String returnAddress) {
        if (Objects.isNull(this.parameters)) {
            this.setParameters(Collections.emptyMap());
        }
        return ActionInput.builder().queueName(this.type).actionContext(ActionContext.builder().did(deltaFile.getDid()).name(this.name).ingressFlow(deltaFile.getSourceInfo().getFlow()).egressFlow(egressFlow).systemName(systemName).build()).actionParams(this.parameters).deltaFile(deltaFile.forQueue(this.name)).returnAddress(returnAddress).build();
    }

    public List<String> validate(ActionDescriptor actionDescriptor) {
        return this.validateType(actionDescriptor);
    }

    public List<String> validateType(ActionDescriptor actionDescriptor) {
        ArrayList<String> errors = new ArrayList<String>();
        if (actionDescriptor.getType() != this.actionType) {
            errors.add("Action: " + this.type + " is not registered as an action of type " + this.actionType);
        }
        return errors;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

