/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.ActionContext;
import org.deltafi.common.types.ActionInput;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.DeltaFile;
import org.springframework.data.annotation.PersistenceCreator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class JoinActionConfiguration
extends ActionConfiguration {
    private String maxAge;
    private Integer maxNum;
    private String metadataKey;
    private String metadataIndexKey;

    public JoinActionConfiguration(String name, String type, String maxAge) {
        super(name, ActionType.JOIN, type);
        this.maxAge = maxAge;
    }

    @PersistenceCreator
    @JsonCreator
    public JoinActionConfiguration(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="actionType") ActionType actionType, @JsonProperty(value="type", required=true) String type, @JsonProperty(value="maxAge", required=true) String maxAge) {
        this(name, type, maxAge);
    }

    public ActionInput buildActionInput(String flow, DeltaFile deltaFile, List<DeltaFile> joinedDeltaFiles, String systemName, String egressFlow) {
        if (Objects.isNull(this.parameters)) {
            this.setParameters(Collections.emptyMap());
        }
        return ActionInput.builder().queueName(this.type).actionContext(ActionContext.builder().did(deltaFile.getDid()).name(this.name).ingressFlow(flow).egressFlow(egressFlow).systemName(systemName).build()).actionParams(this.parameters).deltaFile(deltaFile.forQueue(this.name)).joinedDeltaFiles(joinedDeltaFiles.stream().map(joinedDeltaFile -> joinedDeltaFile.forQueue(this.name)).collect(Collectors.toList())).build();
    }

    public String getMaxAge() {
        return this.maxAge;
    }

    public Integer getMaxNum() {
        return this.maxNum;
    }

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public String getMetadataIndexKey() {
        return this.metadataIndexKey;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    public void setMaxNum(Integer maxNum) {
        this.maxNum = maxNum;
    }

    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }

    public void setMetadataIndexKey(String metadataIndexKey) {
        this.metadataIndexKey = metadataIndexKey;
    }
}

