/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.deltafi.common.action.ActionEventQueueProperties;
import org.deltafi.common.queue.jedis.JedisKeyedBlockingQueue;
import org.deltafi.common.types.ActionEventInput;
import org.deltafi.common.types.ActionInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class ActionEventQueue {
    private static final Logger log = LoggerFactory.getLogger(ActionEventQueue.class);
    private static final String DGS_QUEUE = "dgs";
    private final JedisKeyedBlockingQueue jedisKeyedBlockingQueue;

    public ActionEventQueue(ActionEventQueueProperties actionEventQueueProperties, int poolSize) throws URISyntaxException {
        int maxIdle = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxIdle();
        int maxTotal = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxTotal();
        this.jedisKeyedBlockingQueue = new JedisKeyedBlockingQueue(actionEventQueueProperties.getUrl(), actionEventQueueProperties.getPassword(), maxIdle, maxTotal);
        log.info("Jedis pool size: " + maxTotal);
    }

    public void putActions(List<ActionInput> actionInputs) throws JedisConnectionException {
        ArrayList<Pair<String, Object>> actions = new ArrayList<Pair<String, Object>>();
        for (ActionInput actionInput : actionInputs) {
            actions.add((Pair<String, Object>)Pair.of((Object)actionInput.getQueueName(), (Object)actionInput));
        }
        try {
            this.jedisKeyedBlockingQueue.put(actions);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to convert action to JSON", (Throwable)e);
        }
    }

    public ActionInput takeAction(String actionClassName) throws JsonProcessingException, JedisConnectionException {
        return this.jedisKeyedBlockingQueue.take(actionClassName, ActionInput.class);
    }

    private String queueName(String returnAddress) {
        Object queueName = DGS_QUEUE;
        if (returnAddress != null) {
            queueName = (String)queueName + "-" + returnAddress;
        }
        return queueName;
    }

    public void putResult(ActionEventInput result, String returnAddress) throws JsonProcessingException, JedisConnectionException {
        this.jedisKeyedBlockingQueue.put(this.queueName(returnAddress), result);
    }

    public ActionEventInput takeResult(String returnAddress) throws JsonProcessingException {
        return this.jedisKeyedBlockingQueue.take(this.queueName(returnAddress), ActionEventInput.class);
    }

    public void setHeartbeat(String key) {
        this.jedisKeyedBlockingQueue.setHeartbeat(key);
    }

    public void drop(List<String> actionNames) {
        this.jedisKeyedBlockingQueue.drop(actionNames);
    }
}

