/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.nifi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.util.FlowFileUnpackager;

public class FlowFileUnpackagerV1Unicode
implements FlowFileUnpackager {
    private int flowFilesRead = 0;
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<entry key=\"([^\"]+)\">([^<]+)</entry>", 8);

    public Map<String, String> unpackageFlowFile(InputStream in, OutputStream out) throws IOException {
        ++this.flowFilesRead;
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(in);){
            int bytesRead;
            TarArchiveEntry attribEntry = tarIn.getNextTarEntry();
            if (attribEntry == null || !attribEntry.getName().equals("flowfile.attributes")) {
                throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
            }
            Map<String, String> attributes = this.readAttributes(tarIn);
            TarArchiveEntry contentEntry = tarIn.getNextTarEntry();
            if (contentEntry == null || !contentEntry.getName().equals("flowfile.content")) {
                throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
            }
            byte[] buffer = new byte[524288];
            while ((bytesRead = tarIn.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            Map<String, String> map = attributes;
            return map;
        }
    }

    private Map<String, String> readAttributes(TarArchiveInputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream));
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher entryMatcher = ENTRY_PATTERN.matcher(reader.lines().collect(Collectors.joining("\n")));
        while (entryMatcher.find()) {
            attributes.put(StringEscapeUtils.unescapeXml((String)entryMatcher.group(1)), StringEscapeUtils.unescapeXml((String)entryMatcher.group(2)));
        }
        return attributes;
    }

    public boolean hasMoreData() {
        return this.flowFilesRead == 0;
    }
}

