/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.ActionType;

public class RequiresDomainsActionConfiguration
extends ActionConfiguration {
    private final List<String> requiresDomains;

    public RequiresDomainsActionConfiguration(String name, ActionType actionType, String type, List<String> requiresDomains) {
        super(name, actionType, type);
        this.requiresDomains = requiresDomains;
    }

    @Override
    public List<String> validate(ActionDescriptor actionDescriptor) {
        List<String> errors = this.validateType(actionDescriptor);
        if (null == actionDescriptor.getRequiresDomains() || actionDescriptor.getRequiresDomains().isEmpty()) {
            errors.add("The action configuration requiresDomains must have one or more values");
        }
        if (!ActionConfiguration.equalOrAny(actionDescriptor.getRequiresDomains(), this.requiresDomains)) {
            errors.add("The action configuration requiresDomains value must be: " + actionDescriptor.getRequiresDomains());
        }
        return errors;
    }

    public List<String> getRequiresDomains() {
        return this.requiresDomains;
    }
}

