/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.deltafi.common.content.Segment;
import org.deltafi.common.types.Action;
import org.deltafi.common.types.ActionEventInput;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFileMessage;
import org.deltafi.common.types.DeltaFileStage;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.Egress;
import org.deltafi.common.types.Enrichment;
import org.deltafi.common.types.FormattedData;
import org.deltafi.common.types.ProtocolLayer;
import org.deltafi.common.types.SourceInfo;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DeltaFile {
    @Id
    private String did;
    private List<String> parentDids;
    private List<String> childDids;
    private int requeueCount;
    private long ingressBytes;
    private long referencedBytes;
    private long totalBytes;
    private DeltaFileStage stage;
    private List<Action> actions;
    private SourceInfo sourceInfo;
    private List<ProtocolLayer> protocolStack;
    private List<Domain> domains;
    @Transient
    private Map<String, String> metadata;
    private Map<String, String> indexedMetadata = new HashMap<String, String>();
    private Set<String> indexedMetadataKeys = new HashSet<String>();
    private List<Enrichment> enrichment;
    private List<Egress> egress;
    private List<FormattedData> formattedData;
    private OffsetDateTime created;
    private OffsetDateTime modified;
    private OffsetDateTime contentDeleted;
    private String contentDeletedReason;
    private OffsetDateTime errorAcknowledged;
    private String errorAcknowledgedReason;
    private Boolean testMode;
    private String testModeReason;
    private Boolean egressed;
    private Boolean filtered;
    private OffsetDateTime replayed;
    private String replayDid;
    private OffsetDateTime nextAutoResume;
    private String nextAutoResumeReason;
    @Version
    @JsonIgnore
    private long version;

    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>(this.sourceInfo.getMetadata());
        for (ProtocolLayer protocolLayer : this.protocolStack) {
            metadata.putAll(protocolLayer.getMetadata());
        }
        return metadata;
    }

    public void queueAction(String name) {
        Optional<Action> maybeAction = this.actionNamed(name);
        if (maybeAction.isPresent()) {
            this.setActionState(maybeAction.get(), ActionState.QUEUED, null, null);
        } else {
            this.queueNewAction(name);
        }
    }

    public void queueNewAction(String name) {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().add(Action.newBuilder().name(name).state(ActionState.QUEUED).created(now).queued(now).modified(now).attempt(1 + this.getLastAttemptNum(name)).build());
    }

    private int getLastAttemptNum(String name) {
        Optional<Action> action = this.getActions().stream().filter(a -> a.getName().equals(name) && this.retried((Action)a)).reduce((first, second) -> second);
        return action.map(Action::getAttempt).orElse(0);
    }

    public Optional<Action> actionNamed(String name) {
        return this.getActions().stream().filter(a -> a.getName().equals(name) && !this.retried((Action)a)).reduce((first, second) -> second);
    }

    public boolean isNewAction(String name) {
        return this.actionNamed(name).isEmpty();
    }

    public void queueActionsIfNew(List<String> actions) {
        actions.stream().filter(this::isNewAction).forEach(this::queueNewAction);
    }

    public void completeAction(ActionEventInput event) {
        this.completeAction(event.getAction(), event.getStart(), event.getStop());
    }

    public void completeAction(String name, OffsetDateTime start, OffsetDateTime stop) {
        this.getActions().stream().filter(action -> action.getName().equals(name) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.COMPLETE, start, stop));
    }

    public void filterAction(ActionEventInput event, String filterMessage) {
        this.getActions().stream().filter(action -> action.getName().equals(event.getAction()) && !this.terminalState(action.getState())).forEach(action -> this.setFilteredActionState((Action)action, event.getStart(), event.getStop(), filterMessage));
    }

    public void reinjectAction(ActionEventInput event) {
        this.getActions().stream().filter(action -> action.getName().equals(event.getAction()) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.REINJECTED, event.getStart(), event.getStop()));
    }

    public Action lastAction() {
        return this.getActions().get(this.getActions().size() - 1);
    }

    public void setLastActionReinjected() {
        this.lastAction().setState(ActionState.REINJECTED);
    }

    public void removeLastAction() {
        this.getActions().remove(this.lastAction());
    }

    public void errorAction(ActionEventInput event) {
        this.errorAction(event.getAction(), event.getStart(), event.getStop(), event.getError().getCause(), event.getError().getContext());
    }

    public void errorAction(ActionEventInput event, String policyName, Integer delay) {
        this.setNextAutoResumeReason(policyName);
        this.errorAction(event.getAction(), event.getStart(), event.getStop(), event.getError().getCause(), event.getError().getContext(), event.getStop().plusSeconds(delay.intValue()));
    }

    public void errorAction(ActionEventInput event, String errorCause, String errorContext) {
        this.errorAction(event.getAction(), event.getStart(), event.getStop(), errorCause, errorContext, null);
    }

    public void errorAction(String name, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext) {
        this.errorAction(name, start, stop, errorCause, errorContext, null);
    }

    public void errorAction(String name, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext, OffsetDateTime nextAutoResume) {
        this.getActions().stream().filter(action -> action.getName().equals(name) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.ERROR, start, stop, errorCause, errorContext, nextAutoResume));
    }

    public List<String> retryErrors() {
        List<Action> actionsToRetry = this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.ERROR)).toList();
        actionsToRetry.forEach(action -> action.setState(ActionState.RETRIED));
        this.setNextAutoResume(null);
        return actionsToRetry.stream().map(Action::getName).toList();
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop) {
        this.setActionState(action, actionState, start, stop, null, null, null);
    }

    private void setFilteredActionState(Action action, OffsetDateTime start, OffsetDateTime stop, String filteredCause) {
        action.setFilteredCause(filteredCause);
        this.setActionState(action, ActionState.FILTERED, start, stop);
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext, OffsetDateTime nextAutoResume) {
        OffsetDateTime now = OffsetDateTime.now();
        action.setState(actionState);
        if (action.getCreated() == null) {
            action.setCreated(now);
        }
        action.setStart(start);
        action.setStop(stop);
        action.setModified(now);
        action.setErrorCause(errorCause);
        action.setErrorContext(errorContext);
        this.setModified(now);
        this.setNextAutoResume(nextAutoResume);
    }

    public void setTestModeReason(String reason) {
        this.testMode = null != reason;
        this.testModeReason = reason;
    }

    public List<String> queuedActions() {
        return this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.QUEUED)).map(Action::getName).toList();
    }

    public void addDomain(@NotNull String domainKey, String domainValue, @NotNull String mediaType) {
        Optional<Domain> domain = this.getDomains().stream().filter(d -> d.getName().equals(domainKey)).findFirst();
        if (domain.isPresent()) {
            domain.get().setValue(domainValue);
        } else {
            this.getDomains().add(new Domain(domainKey, domainValue, mediaType));
        }
    }

    public boolean hasDomains(List<String> domains) {
        return domains.stream().allMatch(domain -> this.getDomains().stream().anyMatch(d -> d.getName().equals(domain)));
    }

    public void addIndexedMetadata(Map<String, String> metadata) {
        if (null == metadata) {
            return;
        }
        this.indexedMetadata.putAll(metadata);
        this.indexedMetadataKeys.addAll(metadata.keySet());
    }

    public void addIndexedMetadataIfAbsent(Map<String, String> metadata) {
        metadata.forEach(this::addIndexedMetadataIfAbsent);
    }

    public void addIndexedMetadataIfAbsent(String key, String value) {
        if (null == key || this.indexedMetadata.containsKey(key)) {
            return;
        }
        this.indexedMetadata.put(key, value);
        this.indexedMetadataKeys.add(key);
    }

    public void addEgressFlow(@NotNull String flow) {
        if (!this.getEgress().stream().map(Egress::getFlow).toList().contains(flow)) {
            this.getEgress().add(new Egress(flow));
        }
    }

    public Enrichment getEnrichment(String enrichment) {
        return this.getEnrichment().stream().filter(e -> e.getName().equals(enrichment)).findFirst().orElse(null);
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue) {
        this.addEnrichment(enrichmentKey, enrichmentValue, "application/octet-stream");
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue, @NotNull String mediaType) {
        Optional<Enrichment> enrichment = this.getEnrichment().stream().filter(d -> d.getName().equals(enrichmentKey)).findFirst();
        if (enrichment.isPresent()) {
            enrichment.get().setValue(enrichmentValue);
        } else {
            this.getEnrichment().add(new Enrichment(enrichmentKey, enrichmentValue, mediaType));
        }
    }

    public boolean hasEnrichments(List<String> enrichments) {
        return enrichments.stream().allMatch(enrichment -> this.getEnrichment().stream().anyMatch(e -> e.getName().equals(enrichment)));
    }

    public boolean hasErroredAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.ERROR));
    }

    public boolean hasPendingActions() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.QUEUED));
    }

    public boolean hasFilteredAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.FILTERED));
    }

    public boolean hasReinjectedAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.REINJECTED));
    }

    public boolean noPendingAction(String name) {
        return this.getActions().stream().noneMatch(action -> action.getName().equals(name) && !this.terminalState(action.getState()));
    }

    private boolean terminalState(ActionState actionState) {
        return !actionState.equals((Object)ActionState.QUEUED);
    }

    private boolean retried(Action action) {
        return action.getState().equals((Object)ActionState.RETRIED);
    }

    public boolean hasTerminalAction(String name) {
        return this.getActions().stream().anyMatch(action -> action.getName().equals(name) && !this.retried((Action)action) && this.terminalState(action.getState()));
    }

    public boolean hasCompletedAction(String name) {
        return this.getActions().stream().anyMatch(action -> action.getName().equals(name) && action.getState().equals((Object)ActionState.COMPLETE));
    }

    public boolean hasCompletedActions(List<String> names) {
        return names.stream().allMatch(this::hasCompletedAction);
    }

    public String sourceMetadata(String key) {
        return this.getSourceInfo().getMetadata().get(key);
    }

    public String sourceMetadata(String key, String defaultValue) {
        return this.getSourceInfo().getMetadata().getOrDefault(key, defaultValue);
    }

    @JsonIgnore
    public ProtocolLayer getLastProtocolLayer() {
        return Objects.isNull(this.getProtocolStack()) || this.getProtocolStack().isEmpty() ? null : this.getProtocolStack().get(this.getProtocolStack().size() - 1);
    }

    @JsonIgnore
    @NotNull
    public List<Content> getLastProtocolLayerContent() {
        if (Objects.isNull(this.getLastProtocolLayer()) || Objects.isNull(this.getLastProtocolLayer().getContent())) {
            return Collections.emptyList();
        }
        return this.getLastProtocolLayer().getContent();
    }

    @JsonIgnore
    @NotNull
    public Map<String, String> getLastProtocolLayerMetadata() {
        if (Objects.isNull(this.getLastProtocolLayer()) || Objects.isNull(this.getLastProtocolLayer().getMetadata())) {
            return Collections.emptyMap();
        }
        return this.getLastProtocolLayer().getMetadata();
    }

    @NotNull
    public List<Domain> getDomains() {
        return this.domains == null ? Collections.emptyList() : this.domains;
    }

    @NotNull
    public List<Enrichment> getEnrichment() {
        return this.enrichment == null ? Collections.emptyList() : this.enrichment;
    }

    @NotNull
    public List<Egress> getEgress() {
        if (this.egress == null) {
            this.egress = new ArrayList<Egress>();
        }
        return this.egress;
    }

    private FormattedData formattedDataFor(String actionName) {
        return this.formattedData.stream().filter(f -> f.getEgressActions().contains(actionName) || Objects.nonNull(f.getValidateActions()) && f.getValidateActions().contains(actionName)).findFirst().orElse(null);
    }

    public DeltaFileMessage forQueue(String actionName) {
        DeltaFileMessage.DeltaFileMessageBuilder builder = DeltaFileMessage.builder();
        FormattedData formattedData = this.formattedDataFor(actionName);
        if (formattedData == null) {
            builder.contentList(this.getLastProtocolLayerContent()).metadata(this.getMetadata()).domains(this.getDomains()).enrichment(this.getEnrichment());
        } else {
            Content content = new Content(formattedData.getFilename(), formattedData.getContentReference());
            builder.contentList(List.of(content)).metadata(formattedData.getMetadata());
        }
        return builder.build();
    }

    public List<Segment> referencedSegments() {
        List<Segment> segments = this.getProtocolStack().stream().flatMap(p -> p.getContent().stream()).map(Content::getContentReference).flatMap(c -> c.getSegments().stream()).collect(Collectors.toList());
        segments.addAll(this.getFormattedData().stream().map(FormattedData::getContentReference).flatMap(f -> f.getSegments().stream()).toList());
        return segments;
    }

    public List<Segment> storedSegments() {
        List<Segment> segments = this.getProtocolStack().stream().flatMap(p -> p.getContent().stream()).map(Content::getContentReference).flatMap(c -> c.getSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).collect(Collectors.toList());
        segments.addAll(this.getFormattedData().stream().map(FormattedData::getContentReference).flatMap(f -> f.getSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).toList());
        return segments;
    }

    public void recalculateBytes() {
        this.setReferencedBytes(Segment.calculateTotalSize(this.referencedSegments()));
        this.setTotalBytes(Segment.calculateTotalSize(this.storedSegments()));
    }

    public void cancelQueuedActions() {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().stream().filter(a -> a.getState().equals((Object)ActionState.QUEUED)).forEach(a -> {
            a.setState(ActionState.CANCELLED);
            a.setModified(now);
        });
        this.setModified(now);
    }

    public void incrementRequeueCount() {
        ++this.requeueCount;
    }

    public boolean inactiveStage() {
        return this.getStage() == DeltaFileStage.COMPLETE || this.getStage() == DeltaFileStage.ERROR || this.getStage() == DeltaFileStage.CANCELLED;
    }

    private static List<ProtocolLayer> $default$protocolStack() {
        return new ArrayList<ProtocolLayer>();
    }

    private static Map<String, String> $default$metadata() {
        return new HashMap<String, String>();
    }

    private static List<Egress> $default$egress() {
        return new ArrayList<Egress>();
    }

    private static List<FormattedData> $default$formattedData() {
        return new ArrayList<FormattedData>();
    }

    public static DeltaFileBuilder newBuilder() {
        return new DeltaFileBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public List<String> getParentDids() {
        return this.parentDids;
    }

    public List<String> getChildDids() {
        return this.childDids;
    }

    public int getRequeueCount() {
        return this.requeueCount;
    }

    public long getIngressBytes() {
        return this.ingressBytes;
    }

    public long getReferencedBytes() {
        return this.referencedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public DeltaFileStage getStage() {
        return this.stage;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public List<ProtocolLayer> getProtocolStack() {
        return this.protocolStack;
    }

    public Map<String, String> getIndexedMetadata() {
        return this.indexedMetadata;
    }

    public Set<String> getIndexedMetadataKeys() {
        return this.indexedMetadataKeys;
    }

    public List<FormattedData> getFormattedData() {
        return this.formattedData;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public OffsetDateTime getContentDeleted() {
        return this.contentDeleted;
    }

    public String getContentDeletedReason() {
        return this.contentDeletedReason;
    }

    public OffsetDateTime getErrorAcknowledged() {
        return this.errorAcknowledged;
    }

    public String getErrorAcknowledgedReason() {
        return this.errorAcknowledgedReason;
    }

    public Boolean getTestMode() {
        return this.testMode;
    }

    public String getTestModeReason() {
        return this.testModeReason;
    }

    public Boolean getEgressed() {
        return this.egressed;
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public OffsetDateTime getReplayed() {
        return this.replayed;
    }

    public String getReplayDid() {
        return this.replayDid;
    }

    public OffsetDateTime getNextAutoResume() {
        return this.nextAutoResume;
    }

    public String getNextAutoResumeReason() {
        return this.nextAutoResumeReason;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setParentDids(List<String> parentDids) {
        this.parentDids = parentDids;
    }

    public void setChildDids(List<String> childDids) {
        this.childDids = childDids;
    }

    public void setRequeueCount(int requeueCount) {
        this.requeueCount = requeueCount;
    }

    public void setIngressBytes(long ingressBytes) {
        this.ingressBytes = ingressBytes;
    }

    public void setReferencedBytes(long referencedBytes) {
        this.referencedBytes = referencedBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setStage(DeltaFileStage stage) {
        this.stage = stage;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setProtocolStack(List<ProtocolLayer> protocolStack) {
        this.protocolStack = protocolStack;
    }

    public void setDomains(List<Domain> domains) {
        this.domains = domains;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setIndexedMetadata(Map<String, String> indexedMetadata) {
        this.indexedMetadata = indexedMetadata;
    }

    public void setIndexedMetadataKeys(Set<String> indexedMetadataKeys) {
        this.indexedMetadataKeys = indexedMetadataKeys;
    }

    public void setEnrichment(List<Enrichment> enrichment) {
        this.enrichment = enrichment;
    }

    public void setEgress(List<Egress> egress) {
        this.egress = egress;
    }

    public void setFormattedData(List<FormattedData> formattedData) {
        this.formattedData = formattedData;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setContentDeleted(OffsetDateTime contentDeleted) {
        this.contentDeleted = contentDeleted;
    }

    public void setContentDeletedReason(String contentDeletedReason) {
        this.contentDeletedReason = contentDeletedReason;
    }

    public void setErrorAcknowledged(OffsetDateTime errorAcknowledged) {
        this.errorAcknowledged = errorAcknowledged;
    }

    public void setErrorAcknowledgedReason(String errorAcknowledgedReason) {
        this.errorAcknowledgedReason = errorAcknowledgedReason;
    }

    public void setEgressed(Boolean egressed) {
        this.egressed = egressed;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
    }

    public void setReplayed(OffsetDateTime replayed) {
        this.replayed = replayed;
    }

    public void setReplayDid(String replayDid) {
        this.replayDid = replayDid;
    }

    public void setNextAutoResume(OffsetDateTime nextAutoResume) {
        this.nextAutoResume = nextAutoResume;
    }

    public void setNextAutoResumeReason(String nextAutoResumeReason) {
        this.nextAutoResumeReason = nextAutoResumeReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFile)) {
            return false;
        }
        DeltaFile other = (DeltaFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequeueCount() != other.getRequeueCount()) {
            return false;
        }
        if (this.getIngressBytes() != other.getIngressBytes()) {
            return false;
        }
        if (this.getReferencedBytes() != other.getReferencedBytes()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$testMode = this.getTestMode();
        Boolean other$testMode = other.getTestMode();
        if (this$testMode == null ? other$testMode != null : !((Object)this$testMode).equals(other$testMode)) {
            return false;
        }
        Boolean this$egressed = this.getEgressed();
        Boolean other$egressed = other.getEgressed();
        if (this$egressed == null ? other$egressed != null : !((Object)this$egressed).equals(other$egressed)) {
            return false;
        }
        Boolean this$filtered = this.getFiltered();
        Boolean other$filtered = other.getFiltered();
        if (this$filtered == null ? other$filtered != null : !((Object)this$filtered).equals(other$filtered)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        List<String> this$parentDids = this.getParentDids();
        List<String> other$parentDids = other.getParentDids();
        if (this$parentDids == null ? other$parentDids != null : !((Object)this$parentDids).equals(other$parentDids)) {
            return false;
        }
        List<String> this$childDids = this.getChildDids();
        List<String> other$childDids = other.getChildDids();
        if (this$childDids == null ? other$childDids != null : !((Object)this$childDids).equals(other$childDids)) {
            return false;
        }
        DeltaFileStage this$stage = this.getStage();
        DeltaFileStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !((Object)this$sourceInfo).equals(other$sourceInfo)) {
            return false;
        }
        List<ProtocolLayer> this$protocolStack = this.getProtocolStack();
        List<ProtocolLayer> other$protocolStack = other.getProtocolStack();
        if (this$protocolStack == null ? other$protocolStack != null : !((Object)this$protocolStack).equals(other$protocolStack)) {
            return false;
        }
        List<Domain> this$domains = this.getDomains();
        List<Domain> other$domains = other.getDomains();
        if (this$domains == null ? other$domains != null : !((Object)this$domains).equals(other$domains)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, String> this$indexedMetadata = this.getIndexedMetadata();
        Map<String, String> other$indexedMetadata = other.getIndexedMetadata();
        if (this$indexedMetadata == null ? other$indexedMetadata != null : !((Object)this$indexedMetadata).equals(other$indexedMetadata)) {
            return false;
        }
        Set<String> this$indexedMetadataKeys = this.getIndexedMetadataKeys();
        Set<String> other$indexedMetadataKeys = other.getIndexedMetadataKeys();
        if (this$indexedMetadataKeys == null ? other$indexedMetadataKeys != null : !((Object)this$indexedMetadataKeys).equals(other$indexedMetadataKeys)) {
            return false;
        }
        List<Enrichment> this$enrichment = this.getEnrichment();
        List<Enrichment> other$enrichment = other.getEnrichment();
        if (this$enrichment == null ? other$enrichment != null : !((Object)this$enrichment).equals(other$enrichment)) {
            return false;
        }
        List<Egress> this$egress = this.getEgress();
        List<Egress> other$egress = other.getEgress();
        if (this$egress == null ? other$egress != null : !((Object)this$egress).equals(other$egress)) {
            return false;
        }
        List<FormattedData> this$formattedData = this.getFormattedData();
        List<FormattedData> other$formattedData = other.getFormattedData();
        if (this$formattedData == null ? other$formattedData != null : !((Object)this$formattedData).equals(other$formattedData)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        OffsetDateTime this$contentDeleted = this.getContentDeleted();
        OffsetDateTime other$contentDeleted = other.getContentDeleted();
        if (this$contentDeleted == null ? other$contentDeleted != null : !((Object)this$contentDeleted).equals(other$contentDeleted)) {
            return false;
        }
        String this$contentDeletedReason = this.getContentDeletedReason();
        String other$contentDeletedReason = other.getContentDeletedReason();
        if (this$contentDeletedReason == null ? other$contentDeletedReason != null : !this$contentDeletedReason.equals(other$contentDeletedReason)) {
            return false;
        }
        OffsetDateTime this$errorAcknowledged = this.getErrorAcknowledged();
        OffsetDateTime other$errorAcknowledged = other.getErrorAcknowledged();
        if (this$errorAcknowledged == null ? other$errorAcknowledged != null : !((Object)this$errorAcknowledged).equals(other$errorAcknowledged)) {
            return false;
        }
        String this$errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        String other$errorAcknowledgedReason = other.getErrorAcknowledgedReason();
        if (this$errorAcknowledgedReason == null ? other$errorAcknowledgedReason != null : !this$errorAcknowledgedReason.equals(other$errorAcknowledgedReason)) {
            return false;
        }
        String this$testModeReason = this.getTestModeReason();
        String other$testModeReason = other.getTestModeReason();
        if (this$testModeReason == null ? other$testModeReason != null : !this$testModeReason.equals(other$testModeReason)) {
            return false;
        }
        OffsetDateTime this$replayed = this.getReplayed();
        OffsetDateTime other$replayed = other.getReplayed();
        if (this$replayed == null ? other$replayed != null : !((Object)this$replayed).equals(other$replayed)) {
            return false;
        }
        String this$replayDid = this.getReplayDid();
        String other$replayDid = other.getReplayDid();
        if (this$replayDid == null ? other$replayDid != null : !this$replayDid.equals(other$replayDid)) {
            return false;
        }
        OffsetDateTime this$nextAutoResume = this.getNextAutoResume();
        OffsetDateTime other$nextAutoResume = other.getNextAutoResume();
        if (this$nextAutoResume == null ? other$nextAutoResume != null : !((Object)this$nextAutoResume).equals(other$nextAutoResume)) {
            return false;
        }
        String this$nextAutoResumeReason = this.getNextAutoResumeReason();
        String other$nextAutoResumeReason = other.getNextAutoResumeReason();
        return !(this$nextAutoResumeReason == null ? other$nextAutoResumeReason != null : !this$nextAutoResumeReason.equals(other$nextAutoResumeReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequeueCount();
        long $ingressBytes = this.getIngressBytes();
        result = result * 59 + (int)($ingressBytes >>> 32 ^ $ingressBytes);
        long $referencedBytes = this.getReferencedBytes();
        result = result * 59 + (int)($referencedBytes >>> 32 ^ $referencedBytes);
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Boolean $testMode = this.getTestMode();
        result = result * 59 + ($testMode == null ? 43 : ((Object)$testMode).hashCode());
        Boolean $egressed = this.getEgressed();
        result = result * 59 + ($egressed == null ? 43 : ((Object)$egressed).hashCode());
        Boolean $filtered = this.getFiltered();
        result = result * 59 + ($filtered == null ? 43 : ((Object)$filtered).hashCode());
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        List<String> $parentDids = this.getParentDids();
        result = result * 59 + ($parentDids == null ? 43 : ((Object)$parentDids).hashCode());
        List<String> $childDids = this.getChildDids();
        result = result * 59 + ($childDids == null ? 43 : ((Object)$childDids).hashCode());
        DeltaFileStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : ((Object)$sourceInfo).hashCode());
        List<ProtocolLayer> $protocolStack = this.getProtocolStack();
        result = result * 59 + ($protocolStack == null ? 43 : ((Object)$protocolStack).hashCode());
        List<Domain> $domains = this.getDomains();
        result = result * 59 + ($domains == null ? 43 : ((Object)$domains).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, String> $indexedMetadata = this.getIndexedMetadata();
        result = result * 59 + ($indexedMetadata == null ? 43 : ((Object)$indexedMetadata).hashCode());
        Set<String> $indexedMetadataKeys = this.getIndexedMetadataKeys();
        result = result * 59 + ($indexedMetadataKeys == null ? 43 : ((Object)$indexedMetadataKeys).hashCode());
        List<Enrichment> $enrichment = this.getEnrichment();
        result = result * 59 + ($enrichment == null ? 43 : ((Object)$enrichment).hashCode());
        List<Egress> $egress = this.getEgress();
        result = result * 59 + ($egress == null ? 43 : ((Object)$egress).hashCode());
        List<FormattedData> $formattedData = this.getFormattedData();
        result = result * 59 + ($formattedData == null ? 43 : ((Object)$formattedData).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        OffsetDateTime $contentDeleted = this.getContentDeleted();
        result = result * 59 + ($contentDeleted == null ? 43 : ((Object)$contentDeleted).hashCode());
        String $contentDeletedReason = this.getContentDeletedReason();
        result = result * 59 + ($contentDeletedReason == null ? 43 : $contentDeletedReason.hashCode());
        OffsetDateTime $errorAcknowledged = this.getErrorAcknowledged();
        result = result * 59 + ($errorAcknowledged == null ? 43 : ((Object)$errorAcknowledged).hashCode());
        String $errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        result = result * 59 + ($errorAcknowledgedReason == null ? 43 : $errorAcknowledgedReason.hashCode());
        String $testModeReason = this.getTestModeReason();
        result = result * 59 + ($testModeReason == null ? 43 : $testModeReason.hashCode());
        OffsetDateTime $replayed = this.getReplayed();
        result = result * 59 + ($replayed == null ? 43 : ((Object)$replayed).hashCode());
        String $replayDid = this.getReplayDid();
        result = result * 59 + ($replayDid == null ? 43 : $replayDid.hashCode());
        OffsetDateTime $nextAutoResume = this.getNextAutoResume();
        result = result * 59 + ($nextAutoResume == null ? 43 : ((Object)$nextAutoResume).hashCode());
        String $nextAutoResumeReason = this.getNextAutoResumeReason();
        result = result * 59 + ($nextAutoResumeReason == null ? 43 : $nextAutoResumeReason.hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFile(did=" + this.getDid() + ", parentDids=" + this.getParentDids() + ", childDids=" + this.getChildDids() + ", requeueCount=" + this.getRequeueCount() + ", ingressBytes=" + this.getIngressBytes() + ", referencedBytes=" + this.getReferencedBytes() + ", totalBytes=" + this.getTotalBytes() + ", stage=" + this.getStage() + ", actions=" + this.getActions() + ", sourceInfo=" + this.getSourceInfo() + ", protocolStack=" + this.getProtocolStack() + ", domains=" + this.getDomains() + ", metadata=" + this.getMetadata() + ", indexedMetadata=" + this.getIndexedMetadata() + ", indexedMetadataKeys=" + this.getIndexedMetadataKeys() + ", enrichment=" + this.getEnrichment() + ", egress=" + this.getEgress() + ", formattedData=" + this.getFormattedData() + ", created=" + this.getCreated() + ", modified=" + this.getModified() + ", contentDeleted=" + this.getContentDeleted() + ", contentDeletedReason=" + this.getContentDeletedReason() + ", errorAcknowledged=" + this.getErrorAcknowledged() + ", errorAcknowledgedReason=" + this.getErrorAcknowledgedReason() + ", testMode=" + this.getTestMode() + ", testModeReason=" + this.getTestModeReason() + ", egressed=" + this.getEgressed() + ", filtered=" + this.getFiltered() + ", replayed=" + this.getReplayed() + ", replayDid=" + this.getReplayDid() + ", nextAutoResume=" + this.getNextAutoResume() + ", nextAutoResumeReason=" + this.getNextAutoResumeReason() + ", version=" + this.getVersion() + ")";
    }

    public DeltaFile() {
        this.protocolStack = DeltaFile.$default$protocolStack();
        this.metadata = DeltaFile.$default$metadata();
        this.egress = DeltaFile.$default$egress();
        this.formattedData = DeltaFile.$default$formattedData();
    }

    public DeltaFile(String did, List<String> parentDids, List<String> childDids, int requeueCount, long ingressBytes, long referencedBytes, long totalBytes, DeltaFileStage stage, List<Action> actions, SourceInfo sourceInfo, List<ProtocolLayer> protocolStack, List<Domain> domains, Map<String, String> metadata, Map<String, String> indexedMetadata, Set<String> indexedMetadataKeys, List<Enrichment> enrichment, List<Egress> egress, List<FormattedData> formattedData, OffsetDateTime created, OffsetDateTime modified, OffsetDateTime contentDeleted, String contentDeletedReason, OffsetDateTime errorAcknowledged, String errorAcknowledgedReason, Boolean testMode, String testModeReason, Boolean egressed, Boolean filtered, OffsetDateTime replayed, String replayDid, OffsetDateTime nextAutoResume, String nextAutoResumeReason, long version) {
        this.did = did;
        this.parentDids = parentDids;
        this.childDids = childDids;
        this.requeueCount = requeueCount;
        this.ingressBytes = ingressBytes;
        this.referencedBytes = referencedBytes;
        this.totalBytes = totalBytes;
        this.stage = stage;
        this.actions = actions;
        this.sourceInfo = sourceInfo;
        this.protocolStack = protocolStack;
        this.domains = domains;
        this.metadata = metadata;
        this.indexedMetadata = indexedMetadata;
        this.indexedMetadataKeys = indexedMetadataKeys;
        this.enrichment = enrichment;
        this.egress = egress;
        this.formattedData = formattedData;
        this.created = created;
        this.modified = modified;
        this.contentDeleted = contentDeleted;
        this.contentDeletedReason = contentDeletedReason;
        this.errorAcknowledged = errorAcknowledged;
        this.errorAcknowledgedReason = errorAcknowledgedReason;
        this.testMode = testMode;
        this.testModeReason = testModeReason;
        this.egressed = egressed;
        this.filtered = filtered;
        this.replayed = replayed;
        this.replayDid = replayDid;
        this.nextAutoResume = nextAutoResume;
        this.nextAutoResumeReason = nextAutoResumeReason;
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    @JsonIgnore
    public void setVersion(long version) {
        this.version = version;
    }

    public static class DeltaFileBuilder {
        private String did;
        private List<String> parentDids;
        private List<String> childDids;
        private int requeueCount;
        private long ingressBytes;
        private long referencedBytes;
        private long totalBytes;
        private DeltaFileStage stage;
        private List<Action> actions;
        private SourceInfo sourceInfo;
        private boolean protocolStack$set;
        private List<ProtocolLayer> protocolStack$value;
        private List<Domain> domains;
        private boolean metadata$set;
        private Map<String, String> metadata$value;
        private List<Enrichment> enrichment;
        private boolean egress$set;
        private List<Egress> egress$value;
        private boolean formattedData$set;
        private List<FormattedData> formattedData$value;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private OffsetDateTime contentDeleted;
        private String contentDeletedReason;
        private OffsetDateTime errorAcknowledged;
        private String errorAcknowledgedReason;
        private Boolean testMode;
        private String testModeReason;
        private Boolean egressed;
        private Boolean filtered;
        private OffsetDateTime replayed;
        private String replayDid;
        private OffsetDateTime nextAutoResume;
        private String nextAutoResumeReason;
        private long version;
        private Map<String, String> indexedMetadata = new HashMap<String, String>();
        private Set<String> indexedMetadataKeys = new HashSet<String>();

        public DeltaFileBuilder indexedMetadata(Map<String, String> indexedMetadata) {
            this.indexedMetadata = indexedMetadata;
            this.indexedMetadataKeys = indexedMetadata.keySet();
            return this;
        }

        DeltaFileBuilder() {
        }

        public DeltaFileBuilder did(String did) {
            this.did = did;
            return this;
        }

        public DeltaFileBuilder parentDids(List<String> parentDids) {
            this.parentDids = parentDids;
            return this;
        }

        public DeltaFileBuilder childDids(List<String> childDids) {
            this.childDids = childDids;
            return this;
        }

        public DeltaFileBuilder requeueCount(int requeueCount) {
            this.requeueCount = requeueCount;
            return this;
        }

        public DeltaFileBuilder ingressBytes(long ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public DeltaFileBuilder referencedBytes(long referencedBytes) {
            this.referencedBytes = referencedBytes;
            return this;
        }

        public DeltaFileBuilder totalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public DeltaFileBuilder stage(DeltaFileStage stage) {
            this.stage = stage;
            return this;
        }

        public DeltaFileBuilder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public DeltaFileBuilder sourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public DeltaFileBuilder protocolStack(List<ProtocolLayer> protocolStack) {
            this.protocolStack$value = protocolStack;
            this.protocolStack$set = true;
            return this;
        }

        public DeltaFileBuilder domains(List<Domain> domains) {
            this.domains = domains;
            return this;
        }

        public DeltaFileBuilder metadata(Map<String, String> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        public DeltaFileBuilder indexedMetadataKeys(Set<String> indexedMetadataKeys) {
            this.indexedMetadataKeys = indexedMetadataKeys;
            return this;
        }

        public DeltaFileBuilder enrichment(List<Enrichment> enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public DeltaFileBuilder egress(List<Egress> egress) {
            this.egress$value = egress;
            this.egress$set = true;
            return this;
        }

        public DeltaFileBuilder formattedData(List<FormattedData> formattedData) {
            this.formattedData$value = formattedData;
            this.formattedData$set = true;
            return this;
        }

        public DeltaFileBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public DeltaFileBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public DeltaFileBuilder contentDeleted(OffsetDateTime contentDeleted) {
            this.contentDeleted = contentDeleted;
            return this;
        }

        public DeltaFileBuilder contentDeletedReason(String contentDeletedReason) {
            this.contentDeletedReason = contentDeletedReason;
            return this;
        }

        public DeltaFileBuilder errorAcknowledged(OffsetDateTime errorAcknowledged) {
            this.errorAcknowledged = errorAcknowledged;
            return this;
        }

        public DeltaFileBuilder errorAcknowledgedReason(String errorAcknowledgedReason) {
            this.errorAcknowledgedReason = errorAcknowledgedReason;
            return this;
        }

        public DeltaFileBuilder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public DeltaFileBuilder testModeReason(String testModeReason) {
            this.testModeReason = testModeReason;
            return this;
        }

        public DeltaFileBuilder egressed(Boolean egressed) {
            this.egressed = egressed;
            return this;
        }

        public DeltaFileBuilder filtered(Boolean filtered) {
            this.filtered = filtered;
            return this;
        }

        public DeltaFileBuilder replayed(OffsetDateTime replayed) {
            this.replayed = replayed;
            return this;
        }

        public DeltaFileBuilder replayDid(String replayDid) {
            this.replayDid = replayDid;
            return this;
        }

        public DeltaFileBuilder nextAutoResume(OffsetDateTime nextAutoResume) {
            this.nextAutoResume = nextAutoResume;
            return this;
        }

        public DeltaFileBuilder nextAutoResumeReason(String nextAutoResumeReason) {
            this.nextAutoResumeReason = nextAutoResumeReason;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder version(long version) {
            this.version = version;
            return this;
        }

        public DeltaFile build() {
            List<ProtocolLayer> protocolStack$value = this.protocolStack$value;
            if (!this.protocolStack$set) {
                protocolStack$value = DeltaFile.$default$protocolStack();
            }
            Map<String, String> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = DeltaFile.$default$metadata();
            }
            List<Egress> egress$value = this.egress$value;
            if (!this.egress$set) {
                egress$value = DeltaFile.$default$egress();
            }
            List<FormattedData> formattedData$value = this.formattedData$value;
            if (!this.formattedData$set) {
                formattedData$value = DeltaFile.$default$formattedData();
            }
            return new DeltaFile(this.did, this.parentDids, this.childDids, this.requeueCount, this.ingressBytes, this.referencedBytes, this.totalBytes, this.stage, this.actions, this.sourceInfo, protocolStack$value, this.domains, metadata$value, this.indexedMetadata, this.indexedMetadataKeys, this.enrichment, egress$value, formattedData$value, this.created, this.modified, this.contentDeleted, this.contentDeletedReason, this.errorAcknowledged, this.errorAcknowledgedReason, this.testMode, this.testModeReason, this.egressed, this.filtered, this.replayed, this.replayDid, this.nextAutoResume, this.nextAutoResumeReason, this.version);
        }

        public String toString() {
            return "DeltaFile.DeltaFileBuilder(did=" + this.did + ", parentDids=" + this.parentDids + ", childDids=" + this.childDids + ", requeueCount=" + this.requeueCount + ", ingressBytes=" + this.ingressBytes + ", referencedBytes=" + this.referencedBytes + ", totalBytes=" + this.totalBytes + ", stage=" + this.stage + ", actions=" + this.actions + ", sourceInfo=" + this.sourceInfo + ", protocolStack$value=" + this.protocolStack$value + ", domains=" + this.domains + ", metadata$value=" + this.metadata$value + ", indexedMetadata=" + this.indexedMetadata + ", indexedMetadataKeys=" + this.indexedMetadataKeys + ", enrichment=" + this.enrichment + ", egress$value=" + this.egress$value + ", formattedData$value=" + this.formattedData$value + ", created=" + this.created + ", modified=" + this.modified + ", contentDeleted=" + this.contentDeleted + ", contentDeletedReason=" + this.contentDeletedReason + ", errorAcknowledged=" + this.errorAcknowledged + ", errorAcknowledgedReason=" + this.errorAcknowledgedReason + ", testMode=" + this.testMode + ", testModeReason=" + this.testModeReason + ", egressed=" + this.egressed + ", filtered=" + this.filtered + ", replayed=" + this.replayed + ", replayDid=" + this.replayDid + ", nextAutoResume=" + this.nextAutoResume + ", nextAutoResumeReason=" + this.nextAutoResumeReason + ", version=" + this.version + ")";
        }
    }
}

