/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.deltafi.common.types.ActionContext;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.Enrichment;
import org.deltafi.common.types.SourceInfo;

public class DeltaFileMessage {
    Map<String, String> metadata;
    List<Content> contentList;
    List<Domain> domains;
    List<Enrichment> enrichment;

    public Map<String, Domain> domainMap() {
        if (this.domains == null) {
            return Collections.emptyMap();
        }
        return this.getDomains().stream().collect(Collectors.toMap(Domain::getName, Function.identity()));
    }

    public Map<String, Enrichment> enrichmentMap() {
        if (this.enrichment == null) {
            return Collections.emptyMap();
        }
        return this.getEnrichment().stream().collect(Collectors.toMap(Enrichment::getName, Function.identity()));
    }

    public SourceInfo buildSourceInfo(ActionContext context) {
        return SourceInfo.builder().flow(context.getIngressFlow()).metadata(this.metadata).build();
    }

    public static DeltaFileMessageBuilder builder() {
        return new DeltaFileMessageBuilder();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<Content> getContentList() {
        return this.contentList;
    }

    public List<Domain> getDomains() {
        return this.domains;
    }

    public List<Enrichment> getEnrichment() {
        return this.enrichment;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setContentList(List<Content> contentList) {
        this.contentList = contentList;
    }

    public void setDomains(List<Domain> domains) {
        this.domains = domains;
    }

    public void setEnrichment(List<Enrichment> enrichment) {
        this.enrichment = enrichment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFileMessage)) {
            return false;
        }
        DeltaFileMessage other = (DeltaFileMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<Content> this$contentList = this.getContentList();
        List<Content> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        List<Domain> this$domains = this.getDomains();
        List<Domain> other$domains = other.getDomains();
        if (this$domains == null ? other$domains != null : !((Object)this$domains).equals(other$domains)) {
            return false;
        }
        List<Enrichment> this$enrichment = this.getEnrichment();
        List<Enrichment> other$enrichment = other.getEnrichment();
        return !(this$enrichment == null ? other$enrichment != null : !((Object)this$enrichment).equals(other$enrichment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFileMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<Content> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        List<Domain> $domains = this.getDomains();
        result = result * 59 + ($domains == null ? 43 : ((Object)$domains).hashCode());
        List<Enrichment> $enrichment = this.getEnrichment();
        result = result * 59 + ($enrichment == null ? 43 : ((Object)$enrichment).hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFileMessage(metadata=" + this.getMetadata() + ", contentList=" + this.getContentList() + ", domains=" + this.getDomains() + ", enrichment=" + this.getEnrichment() + ")";
    }

    public DeltaFileMessage() {
    }

    public DeltaFileMessage(Map<String, String> metadata, List<Content> contentList, List<Domain> domains, List<Enrichment> enrichment) {
        this.metadata = metadata;
        this.contentList = contentList;
        this.domains = domains;
        this.enrichment = enrichment;
    }

    public static class DeltaFileMessageBuilder {
        private Map<String, String> metadata;
        private List<Content> contentList;
        private List<Domain> domains;
        private List<Enrichment> enrichment;

        DeltaFileMessageBuilder() {
        }

        public DeltaFileMessageBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public DeltaFileMessageBuilder contentList(List<Content> contentList) {
            this.contentList = contentList;
            return this;
        }

        public DeltaFileMessageBuilder domains(List<Domain> domains) {
            this.domains = domains;
            return this;
        }

        public DeltaFileMessageBuilder enrichment(List<Enrichment> enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public DeltaFileMessage build() {
            return new DeltaFileMessage(this.metadata, this.contentList, this.domains, this.enrichment);
        }

        public String toString() {
            return "DeltaFileMessage.DeltaFileMessageBuilder(metadata=" + this.metadata + ", contentList=" + this.contentList + ", domains=" + this.domains + ", enrichment=" + this.enrichment + ")";
        }
    }
}

