/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.DomainActionConfiguration;
import org.deltafi.common.types.EnrichActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class EnrichFlowPlan
extends FlowPlan {
    private List<DomainActionConfiguration> domainActions;
    private List<EnrichActionConfiguration> enrichActions;

    public EnrichFlowPlan(String name, String description) {
        super(name, FlowType.ENRICH, description);
    }

    @PersistenceCreator
    @JsonCreator
    public EnrichFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actions = new ArrayList<ActionConfiguration>();
        if (this.domainActions != null) {
            actions.addAll(this.domainActions);
        }
        if (this.enrichActions != null) {
            actions.addAll(this.enrichActions);
        }
        return actions;
    }

    public List<DomainActionConfiguration> getDomainActions() {
        return this.domainActions;
    }

    public List<EnrichActionConfiguration> getEnrichActions() {
        return this.enrichActions;
    }

    public void setDomainActions(List<DomainActionConfiguration> domainActions) {
        this.domainActions = domainActions;
    }

    public void setEnrichActions(List<EnrichActionConfiguration> enrichActions) {
        this.enrichActions = enrichActions;
    }
}

