/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VariableDataType {
    STRING,
    BOOLEAN{

        @Override
        public String formatString(String value) {
            return null != value ? value.trim().toLowerCase(Locale.ROOT) : null;
        }

        @Override
        public String runValidateValue(String value) {
            if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                return "A boolean value must be true or false";
            }
            return null;
        }
    }
    ,
    NUMBER{

        @Override
        public String runValidateValue(String value) {
            if (!NumberUtils.isCreatable((String)value)) {
                return "The value " + value + " cannot be converted to a number";
            }
            return null;
        }
    }
    ,
    LIST{

        @Override
        public String formatString(String value) {
            return 3.wrapIfMissing(value, "[", "]");
        }
    }
    ,
    MAP{

        @Override
        public String formatString(String value) {
            return 4.wrapIfMissing(value, "{", "}");
        }

        @Override
        public String runValidateValue(String value) {
            if (!value.isBlank() && 4.readStringAsMap(value).isEmpty()) {
                return "A map value must be of the form of 'key: value, nextKey: nextValue'";
            }
            return null;
        }
    };


    public String formatString(String value) {
        return null != value ? value.trim() : null;
    }

    public String validateValue(String value) {
        return null == value ? null : this.runValidateValue(value.trim());
    }

    String runValidateValue(String value) {
        return null;
    }

    static String wrapIfMissing(String value, String start, String close) {
        if (!value.startsWith(start) || !value.endsWith(close)) {
            return start + value + close;
        }
        return value;
    }

    public static Map<Object, Object> readStringAsMap(String value) {
        Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.delimitedListToStringArray((String)value, (String)","), (String)":");
        return null == properties ? Map.of() : properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

