/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metric;

import java.util.Date;
import java.util.Map;
import org.deltafi.common.metric.MetricType;

public class Metric {
    private String source;
    private String name;
    private long value;
    private MetricType type;
    private Date timestamp;
    private Map<String, String> tags;

    Metric(String source, String name, long value, MetricType type, Date timestamp, Map<String, String> tags) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.type = type;
        this.timestamp = timestamp;
        this.tags = tags;
    }

    public static MetricBuilder builder() {
        return new MetricBuilder();
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public MetricType getType() {
        return this.type;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setType(MetricType type) {
        this.type = type;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        MetricType this$type = this.getType();
        MetricType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        MetricType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Metric(source=" + this.getSource() + ", name=" + this.getName() + ", value=" + this.getValue() + ", type=" + this.getType() + ", timestamp=" + this.getTimestamp() + ", tags=" + this.getTags() + ")";
    }

    public static class MetricBuilder {
        private String source;
        private String name;
        private long value;
        private MetricType type;
        private Date timestamp;
        private Map<String, String> tags;

        MetricBuilder() {
        }

        public MetricBuilder source(String source) {
            this.source = source;
            return this;
        }

        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricBuilder value(long value) {
            this.value = value;
            return this;
        }

        public MetricBuilder type(MetricType type) {
            this.type = type;
            return this;
        }

        public MetricBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Metric build() {
            return new Metric(this.source, this.name, this.value, this.type, this.timestamp, this.tags);
        }

        public String toString() {
            return "Metric.MetricBuilder(source=" + this.source + ", name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", timestamp=" + this.timestamp + ", tags=" + this.tags + ")";
        }
    }
}

