/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;

public class ContentStorageService {
    private static final String CONTENT_BUCKET = "storage";
    private final ObjectStorageService objectStorageService;

    public InputStream load(ContentReference contentReference) throws ObjectStorageException {
        return contentReference.getSize() > 0L ? this.objectStorageService.getObject(this.buildObjectReference(contentReference)) : InputStream.nullInputStream();
    }

    public ContentReference save(String did, byte[] content, String mediaType) throws ObjectStorageException {
        return this.save(did, new ByteArrayInputStream(content), mediaType);
    }

    public ContentReference save(String did, InputStream inputStream, String mediaType) throws ObjectStorageException {
        ContentReference contentReference = new ContentReference(UUID.randomUUID().toString(), did, mediaType);
        ObjectReference objectReference = this.objectStorageService.putObject(this.buildObjectReference(contentReference), inputStream);
        contentReference.setSize(objectReference.getSize());
        return contentReference;
    }

    public void delete(ContentReference contentReference) {
        this.objectStorageService.removeObject(this.buildObjectReference(contentReference));
    }

    public boolean deleteAll(String did) {
        return this.objectStorageService.removeObjects(CONTENT_BUCKET, did);
    }

    public Set<String> findDidsLastModifiedBefore(ZonedDateTime lastModifiedBefore) {
        return this.objectStorageService.getObjectNames(CONTENT_BUCKET, "", lastModifiedBefore).stream().map(objectName -> objectName.substring(0, objectName.indexOf(47))).collect(Collectors.toSet());
    }

    private ObjectReference buildObjectReference(ContentReference contentReference) {
        return new ObjectReference(CONTENT_BUCKET, contentReference.getDid() + "/" + contentReference.getUuid(), contentReference.getOffset(), contentReference.getSize());
    }

    public ContentStorageService(ObjectStorageService objectStorageService) {
        this.objectStorageService = objectStorageService;
    }
}

