/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metric;

import io.quarkiverse.loggingjson.providers.KeyValueStructuredArgument;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.deltafi.common.metric.Metric;
import org.deltafi.common.metric.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricLogger {
    private static final Logger log = LoggerFactory.getLogger(MetricLogger.class);

    public static void logMetric(String source, String did, String flow, String name, long value) {
        MetricLogger.logMetric(source, did, flow, name, value, Map.of());
    }

    public static void logMetric(String source, String did, String flow, String name, long value, Map<String, String> additionalTags) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("did", did);
        tags.put("flow", flow);
        tags.putAll(additionalTags);
        MetricLogger.logMetric(source, name, value, tags);
    }

    public static void logMetric(String source, String name, long value, Map<String, String> tags) {
        MetricLogger.logMetric(source, MetricType.COUNTER, name, value, tags);
    }

    public static void logMetric(String source, MetricType type, String name, long value, Map<String, String> tags) {
        Metric metric = Metric.builder().source(source).name(name).value(value).type(type).timestamp(new Date()).tags(tags).build();
        log.info("{}", (Object)KeyValueStructuredArgument.kv((String)"metric", (Object)metric));
    }
}

