/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.trace;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;

public class DeltafiSpan
implements Serializable {
    String id;
    String traceId;
    String parentId;
    String name;
    long timestamp;
    long duration;
    String kind;
    Map<String, String> tags;
    Endpoint localEndpoint;
    Endpoint remoteEndpoint;

    public DeltafiSpan(String id, String traceId, String parentId, String name, long timestamp, long duration, String kind, Map<String, String> tags, Endpoint localEndpoint, Endpoint remoteEndpoint) {
        this.id = id;
        this.traceId = traceId;
        this.parentId = parentId;
        this.name = name;
        this.timestamp = timestamp;
        this.duration = duration;
        this.kind = kind;
        this.tags = tags;
        this.localEndpoint = localEndpoint;
        this.remoteEndpoint = remoteEndpoint;
    }

    public static Builder newSpanBuilder() {
        Builder builder = new Builder();
        builder.timestamp = DeltafiSpan.micros();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = DeltafiSpan.micros(timestamp);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Endpoint getLocalEndpoint() {
        return this.localEndpoint;
    }

    public void setLocalEndpoint(Endpoint localEndpoint) {
        this.localEndpoint = localEndpoint;
    }

    public Endpoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(Endpoint remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public void endSpan() {
        this.duration = DeltafiSpan.micros() - this.timestamp;
    }

    public static long micros() {
        return DeltafiSpan.micros(Instant.now());
    }

    public static long micros(Instant time) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, time);
    }

    public String toString() {
        return "DeltafiSpan{id='" + this.id + "', traceId='" + this.traceId + "', parentId='" + this.parentId + "', name='" + this.name + "', timestamp=" + this.timestamp + ", duration=" + this.duration + ", kind='" + this.kind + "', tags=" + this.tags + ", localEndpoint=" + this.localEndpoint + ", remoteEndpoint=" + this.remoteEndpoint + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltafiSpan that = (DeltafiSpan)o;
        return this.timestamp == that.timestamp && this.duration == that.duration && Objects.equals(this.id, that.id) && Objects.equals(this.traceId, that.traceId) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.name, that.name) && Objects.equals(this.kind, that.kind) && Objects.equals(this.tags, that.tags) && Objects.equals(this.localEndpoint, that.localEndpoint) && Objects.equals(this.remoteEndpoint, that.remoteEndpoint);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.traceId, this.parentId, this.name, this.timestamp, this.duration, this.kind, this.tags, this.localEndpoint, this.remoteEndpoint);
    }

    public static class Builder {
        String id;
        String traceId;
        String parentId;
        String name;
        long timestamp;
        long duration;
        String kind;
        Map<String, String> tags;
        Endpoint localEndpoint;
        Endpoint remoteEndpoint;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = DeltafiSpan.micros(timestamp);
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder localEndpoint(String serviceName) {
            this.localEndpoint = new Endpoint(serviceName);
            return this;
        }

        public Builder remoteEndpoint(String serviceName) {
            this.remoteEndpoint = new Endpoint(serviceName);
            return this;
        }

        public DeltafiSpan build() {
            return new DeltafiSpan(this.id, this.traceId, this.parentId, this.name, this.timestamp, this.duration, this.kind, this.tags, this.localEndpoint, this.remoteEndpoint);
        }
    }

    public static class Endpoint
    implements Serializable {
        String serviceName;

        public Endpoint(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }
}

