/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.trace;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipkinRestClient {
    private static final Logger log = LoggerFactory.getLogger(ZipkinRestClient.class);
    private final String url;
    private final HttpClient httpClient;

    public ZipkinRestClient(String url) {
        this.url = url;
        this.httpClient = HttpClient.newHttpClient();
    }

    void sendSpan(String spanJson) {
        ((CompletableFuture)this.httpClient.sendAsync(this.buildRequest(spanJson), HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> this.processResponse((HttpResponse<String>)response, spanJson))).exceptionally(throwable -> this.processException((Throwable)throwable, spanJson));
    }

    public HttpRequest buildRequest(String spanJson) {
        return HttpRequest.newBuilder().uri(URI.create(this.url)).POST(HttpRequest.BodyPublishers.ofString(spanJson)).build();
    }

    public void processResponse(HttpResponse<String> response, String spanJson) {
        if (response.statusCode() < 200 || response.statusCode() > 299 && log.isErrorEnabled()) {
            log.error("Failed to send {} to Zipkin with error of {}", (Object)spanJson, (Object)response.body());
        }
    }

    public Void processException(Throwable throwable, String spanJson) {
        log.error("Failed to send {} to Zipkin with an exception", (Object)spanJson, (Object)throwable);
        return null;
    }
}

