/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;

public interface ObjectStorageService {
    default public List<String> getObjectNames(String bucket, List<String> prefixes) {
        return this.getObjectNames(bucket, prefixes, null);
    }

    public List<String> getObjectNames(String var1, List<String> var2, ZonedDateTime var3);

    public InputStream getObject(ObjectReference var1) throws ObjectStorageException;

    default public byte[] getObjectAsByteArray(ObjectReference objectReference) throws ObjectStorageException, IOException {
        return this.getObject(objectReference).readAllBytes();
    }

    public ObjectReference putObject(ObjectReference var1, InputStream var2) throws ObjectStorageException;

    default public ObjectReference putObjectAsByteArray(ObjectReference objectReference, byte[] object) throws ObjectStorageException {
        return this.putObject(objectReference, new ByteArrayInputStream(object));
    }

    public void removeObject(ObjectReference var1);

    public boolean removeObjects(String var1, List<String> var2);

    public long getObjectSize(String var1, String var2);
}

