/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3.minio;

import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.input.CountingInputStream;
import org.deltafi.common.properties.MinioProperties;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioObjectStorageService
implements ObjectStorageService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectStorageService.class);
    protected final MinioClient minioClient;
    protected final MinioProperties minioProperties;

    @Override
    public List<String> getObjectNames(String bucket, List<String> prefixes, ZonedDateTime lastModifiedBefore) {
        ArrayList<String> names = new ArrayList<String>();
        for (String prefix : prefixes) {
            Iterable objects = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(prefix).recursive(true).build());
            for (Result itemResult : objects) {
                Item item;
                try {
                    item = (Item)itemResult.get();
                }
                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                    log.error("Failed to retrieve minio object for did {}", (Object)prefix, (Object)e);
                    continue;
                }
                if (item.isDir() || lastModifiedBefore != null && !item.lastModified().isBefore(lastModifiedBefore)) continue;
                names.add(item.objectName());
            }
        }
        return names;
    }

    @Override
    public InputStream getObject(ObjectReference objectReference) throws ObjectStorageException {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).offset(Long.valueOf(objectReference.getOffset()))).length(Long.valueOf(objectReference.getSize()))).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ObjectStorageException("Failed to get object from minio", e);
        }
    }

    @Override
    public ObjectReference putObject(ObjectReference objectReference, InputStream inputStream) throws ObjectStorageException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        try {
            ObjectWriteResponse objectWriteResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).stream((InputStream)countingInputStream, objectReference.getSize(), this.minioProperties.getPartSize()).build());
            ObjectReference objectReference2 = new ObjectReference(objectWriteResponse.bucket(), objectWriteResponse.object(), 0L, countingInputStream.getByteCount());
            return objectReference2;
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to save incoming object", e);
            throw new ObjectStorageException("Failed to send incoming data to minio", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close input stream: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void removeObject(ObjectReference objectReference) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to remove object {} from bucket {}", (Object)objectReference.getName(), (Object)objectReference.getBucket());
        }
    }

    @Override
    public boolean removeObjects(String bucket, List<String> prefixes) {
        List objectsInStorage = this.getObjectNames(bucket, prefixes).stream().map(DeleteObject::new).collect(Collectors.toList());
        Iterable removeResults = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(objectsInStorage).build());
        Iterator iterator = removeResults.iterator();
        if (iterator.hasNext()) {
            Result removeResult = (Result)iterator.next();
            try {
                DeleteError error = (DeleteError)removeResult.get();
                log.error("Failed to remove object {} with an error of {}", (Object)error.objectName(), (Object)error.message());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("Failed to remove object: {}", (Object)e.getMessage());
            }
            return false;
        }
        return true;
    }

    @Override
    public long getObjectSize(String bucket, String name) {
        try {
            return this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(name)).build()).size();
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to retrieve object stats for {}/{}", new Object[]{bucket, name, e});
            return 0L;
        }
    }

    public MinioObjectStorageService(MinioClient minioClient, MinioProperties minioProperties) {
        this.minioClient = minioClient;
        this.minioProperties = minioProperties;
    }
}

