/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.deltafi.common.metrics.Metric;
import org.deltafi.common.metrics.MetricsProperties;
import org.deltafi.common.metrics.statsd.StatsdDeltaReporter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRepository {
    private static final Logger log = LoggerFactory.getLogger(MetricRepository.class);
    private final MetricRegistry metrics;

    public MetricRepository(MetricsProperties metricsProperties) {
        if (metricsProperties.isEnabled()) {
            log.info("Creating metric service");
            this.metrics = new MetricRegistry();
            log.info("Starting statsd reporter");
            StatsdDeltaReporter.builder(metricsProperties.getStatsd().getHostname(), metricsProperties.getStatsd().getPort(), this.metrics).build().start(10L, TimeUnit.SECONDS);
            log.info("MetricService initialized.");
        } else {
            log.warn("Metrics are disabled");
            this.metrics = null;
        }
    }

    public void increment(@NotNull Metric metric) {
        if (this.metrics != null) {
            this.metrics.counter(metric.metricName()).inc(metric.getValue());
        }
        log.debug("{}", (Object)metric);
    }

    public void increment(@NotNull String name, @NotNull Map<String, String> tags, long value) {
        Metric metric = new Metric(name, value).addTags(tags);
        if (this.metrics != null) {
            this.metrics.counter(metric.metricName()).inc(value);
        }
        log.debug("{}", (Object)metric);
    }
}

