/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.deltafi.common.types.KeyValue;

public class KeyValueConverter {
    public static Map<String, String> convertKeyValues(List<KeyValue> keyValues) {
        if (keyValues == null) {
            return new HashMap<String, String>();
        }
        return keyValues.stream().collect(CustomCollector.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    public static List<KeyValue> fromMap(Map<String, String> map) {
        if (map == null) {
            return new ArrayList<KeyValue>();
        }
        return map.entrySet().stream().map(KeyValueConverter::fromMapEntry).collect(Collectors.toList());
    }

    public static KeyValue fromMapEntry(Map.Entry<String, String> entry) {
        return new KeyValue(entry.getKey(), entry.getValue());
    }

    static class CustomCollector {
        CustomCollector() {
        }

        public static <T, K, V> Collector<T, Map<K, V>, Map<K, V>> toMap(Function<? super T, K> keyMapper, Function<T, V> valueMapper) {
            return Collector.of(HashMap::new, (kvMap, t) -> kvMap.put(keyMapper.apply(t), valueMapper.apply(t)), (kvMap, kvMap2) -> {
                kvMap.putAll(kvMap2);
                return kvMap;
            }, Function.identity(), Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

