/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.graphql.dgs;

import com.netflix.graphql.dgs.client.GraphQLClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.deltafi.common.graphql.dgs.DeltafiGraphQLException;
import org.deltafi.common.graphql.dgs.GraphqlClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLClientFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphQLClientFactory.class);
    private final HttpClient httpClient;
    private final GraphqlClientProperties graphqlProperties;

    public GraphQLClient build(String ... headers) {
        return GraphQLClient.createCustom((String)this.graphqlProperties.getCore(), (url, defaultHeaders, body) -> {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body));
            if (headers.length > 0) {
                requestBuilder.headers(headers);
            }
            try {
                HttpResponse<String> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                return new com.netflix.graphql.dgs.client.HttpResponse(response.statusCode(), response.body());
            }
            catch (IOException ioException) {
                throw new DeltafiGraphQLException("Failed to make graphQL request", ioException);
            }
            catch (InterruptedException interruptedException) {
                log.error("Could not complete graphQL request", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
                throw new DeltafiGraphQLException("GraphQL Request was interrupted");
            }
        });
    }

    public GraphQLClientFactory(HttpClient httpClient, GraphqlClientProperties graphqlProperties) {
        this.httpClient = httpClient;
        this.graphqlProperties = graphqlProperties;
    }
}

