/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.http;

import java.net.http.HttpClient;
import org.deltafi.common.http.HttpService;
import org.deltafi.common.ssl.SslContextFactory;
import org.deltafi.common.ssl.SslProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConfigurationPropertiesScan
public class HttpServiceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpServiceAutoConfiguration.class);

    @Bean
    @ConfigurationProperties(value="ssl")
    public SslProperties sslProperties() {
        return new SslProperties();
    }

    @Bean
    public HttpClient httpClient(SslProperties sslProperties) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (sslProperties.isEnabled()) {
            try {
                httpClientBuilder.sslContext(SslContextFactory.buildSslContext(sslProperties));
            }
            catch (SslContextFactory.SslException e) {
                log.warn("Unable to build SSL context. SSL will be disabled.", (Throwable)e);
            }
        }
        return httpClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpService httpService(HttpClient httpClient) {
        return new HttpService(httpClient);
    }
}

