/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metrics.statsd;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsdClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(StatsdClient.class);
    private static final Pattern ILLEGAL_CHARACTERS = Pattern.compile("[|:\\s]+");
    private Socket socket;
    private int failCount;
    final String host;
    final int port;
    private final SocketFactory socketFactory;
    private final StreamFactory streamFactory;
    private PrintWriter out = null;

    public StatsdClient(String host, int port) {
        this(host, port, new SocketFactory(), new StreamFactory());
    }

    public void connect() throws IOException {
        if (this.socket != null) {
            ++this.failCount;
            throw new IllegalStateException("Already connected");
        }
        try {
            this.socket = this.socketFactory.create(this.host, this.port);
            this.out = this.streamFactory.create(this.socket);
        }
        catch (Throwable e) {
            this.incrementFailCount(e);
            if (this.socket != null) {
                this.socket.close();
            }
            throw e;
        }
    }

    private void incrementFailCount(Throwable e) {
        ++this.failCount;
        if (this.failCount == 1) {
            log.warn("Unable to transmit metrics to statsd", e);
        } else {
            log.debug("Unable to transmit metrics to statsd", e);
        }
    }

    private void send(String name, String value, String format) {
        String message = String.format(format, this.sanitize(name), value);
        try {
            this.out.println(message);
        }
        catch (Throwable e) {
            this.incrementFailCount(e);
            throw e;
        }
        if (this.failCount > 0) {
            log.info("Resumed sending metrics to statsd");
            this.failCount = 0;
        }
    }

    public void sendCounter(String name, String value) {
        this.send(name, value, "%s:%s|c");
    }

    public void sendGauge(String name, String value) {
        this.send(name, value, "%s:%s|g");
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable e) {
                this.incrementFailCount(e);
            }
        }
        this.socket = null;
    }

    private String sanitize(String s) {
        return ILLEGAL_CHARACTERS.matcher(s).replaceAll("-");
    }

    public boolean success() {
        return this.failCount == 0;
    }

    public StatsdClient(String host, int port, SocketFactory socketFactory, StreamFactory streamFactory) {
        this.host = host;
        this.port = port;
        this.socketFactory = socketFactory;
        this.streamFactory = streamFactory;
    }

    public static class StreamFactory {
        public PrintWriter create(Socket socket) throws IOException {
            return new PrintWriter(socket.getOutputStream(), true);
        }
    }

    public static class SocketFactory {
        public Socket create(String host, int port) throws IOException {
            return new Socket(host, port);
        }
    }
}

