/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.List;
import java.util.Objects;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.PluginCoordinates;
import org.deltafi.common.types.PropertySet;
import org.deltafi.common.types.Variable;

public class Plugin {
    private PluginCoordinates pluginCoordinates;
    private String displayName;
    private String description;
    private String actionKitVersion;
    private List<ActionDescriptor> actions;
    private List<PluginCoordinates> dependencies;
    private List<PropertySet> propertySets;
    private List<Variable> variables;

    public Plugin() {
    }

    public Plugin(PluginCoordinates pluginCoordinates, String displayName, String description, String actionKitVersion, List<ActionDescriptor> actions, List<PluginCoordinates> dependencies, List<PropertySet> propertySets, List<Variable> variables) {
        this.pluginCoordinates = pluginCoordinates;
        this.displayName = displayName;
        this.description = description;
        this.actionKitVersion = actionKitVersion;
        this.actions = actions;
        this.dependencies = dependencies;
        this.propertySets = propertySets;
        this.variables = variables;
    }

    public PluginCoordinates getPluginCoordinates() {
        return this.pluginCoordinates;
    }

    public void setPluginCoordinates(PluginCoordinates pluginCoordinates) {
        this.pluginCoordinates = pluginCoordinates;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getActionKitVersion() {
        return this.actionKitVersion;
    }

    public void setActionKitVersion(String actionKitVersion) {
        this.actionKitVersion = actionKitVersion;
    }

    public List<ActionDescriptor> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionDescriptor> actions) {
        this.actions = actions;
    }

    public List<PluginCoordinates> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<PluginCoordinates> dependencies) {
        this.dependencies = dependencies;
    }

    public List<PropertySet> getPropertySets() {
        return this.propertySets;
    }

    public void setPropertySets(List<PropertySet> propertySets) {
        this.propertySets = propertySets;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public String toString() {
        return "Plugin{pluginCoordinates='" + this.pluginCoordinates + "',displayName='" + this.displayName + "',description='" + this.description + "',actionKitVersion='" + this.actionKitVersion + "',actions='" + this.actions + "',dependencies='" + this.dependencies + "',propertySets='" + this.propertySets + "',variables='" + this.variables + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin that = (Plugin)o;
        return Objects.equals(this.pluginCoordinates, that.pluginCoordinates) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.actionKitVersion, that.actionKitVersion) && Objects.equals(this.actions, that.actions) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.propertySets, that.propertySets) && Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.pluginCoordinates, this.displayName, this.description, this.actionKitVersion, this.actions, this.dependencies, this.propertySets, this.variables);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PluginCoordinates pluginCoordinates;
        private String displayName;
        private String description;
        private String actionKitVersion;
        private List<ActionDescriptor> actions;
        private List<PluginCoordinates> dependencies;
        private List<PropertySet> propertySets;
        private List<Variable> variables;

        public Plugin build() {
            Plugin result = new Plugin();
            result.pluginCoordinates = this.pluginCoordinates;
            result.displayName = this.displayName;
            result.description = this.description;
            result.actionKitVersion = this.actionKitVersion;
            result.actions = this.actions;
            result.dependencies = this.dependencies;
            result.propertySets = this.propertySets;
            result.variables = this.variables;
            return result;
        }

        public Builder pluginCoordinates(PluginCoordinates pluginCoordinates) {
            this.pluginCoordinates = pluginCoordinates;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder actionKitVersion(String actionKitVersion) {
            this.actionKitVersion = actionKitVersion;
            return this;
        }

        public Builder actions(List<ActionDescriptor> actions) {
            this.actions = actions;
            return this;
        }

        public Builder dependencies(List<PluginCoordinates> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder propertySets(List<PropertySet> propertySets) {
            this.propertySets = propertySets;
            return this;
        }

        public Builder variables(List<Variable> variables) {
            this.variables = variables;
            return this;
        }
    }
}

