/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import org.deltafi.common.types.PropertySource;

public class Property {
    private String key;
    private String value;
    private String description;
    private String defaultValue;
    private PropertySource propertySource;
    private boolean refreshable;
    private boolean editable;
    private boolean hidden;

    public boolean hasValue() {
        return null != this.value;
    }

    public static PropertyBuilder builder() {
        return new PropertyBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPropertySource(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRefreshable() != other.isRefreshable()) {
            return false;
        }
        if (this.isEditable() != other.isEditable()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        PropertySource this$propertySource = this.getPropertySource();
        PropertySource other$propertySource = other.getPropertySource();
        return !(this$propertySource == null ? other$propertySource != null : !((Object)((Object)this$propertySource)).equals((Object)other$propertySource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRefreshable() ? 79 : 97);
        result = result * 59 + (this.isEditable() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        PropertySource $propertySource = this.getPropertySource();
        result = result * 59 + ($propertySource == null ? 43 : ((Object)((Object)$propertySource)).hashCode());
        return result;
    }

    public String toString() {
        return "Property(key=" + this.getKey() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", propertySource=" + this.getPropertySource() + ", refreshable=" + this.isRefreshable() + ", editable=" + this.isEditable() + ", hidden=" + this.isHidden() + ")";
    }

    public Property() {
    }

    public Property(String key, String value, String description, String defaultValue, PropertySource propertySource, boolean refreshable, boolean editable, boolean hidden) {
        this.key = key;
        this.value = value;
        this.description = description;
        this.defaultValue = defaultValue;
        this.propertySource = propertySource;
        this.refreshable = refreshable;
        this.editable = editable;
        this.hidden = hidden;
    }

    public static class PropertyBuilder {
        private String key;
        private String value;
        private String description;
        private String defaultValue;
        private PropertySource propertySource;
        private boolean refreshable;
        private boolean editable;
        private boolean hidden;

        PropertyBuilder() {
        }

        public PropertyBuilder key(String key) {
            this.key = key;
            return this;
        }

        public PropertyBuilder value(String value) {
            this.value = value;
            return this;
        }

        public PropertyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PropertyBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PropertyBuilder propertySource(PropertySource propertySource) {
            this.propertySource = propertySource;
            return this;
        }

        public PropertyBuilder refreshable(boolean refreshable) {
            this.refreshable = refreshable;
            return this;
        }

        public PropertyBuilder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public PropertyBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Property build() {
            return new Property(this.key, this.value, this.description, this.defaultValue, this.propertySource, this.refreshable, this.editable, this.hidden);
        }

        public String toString() {
            return "Property.PropertyBuilder(key=" + this.key + ", value=" + this.value + ", description=" + this.description + ", defaultValue=" + this.defaultValue + ", propertySource=" + this.propertySource + ", refreshable=" + this.refreshable + ", editable=" + this.editable + ", hidden=" + this.hidden + ")";
        }
    }
}

