/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metrics.statsd;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.deltafi.common.metrics.statsd.StatsdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StatsdDeltaReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(StatsdDeltaReporter.class);
    private final StatsdClient statsdClient;
    private final String prefix;

    protected StatsdDeltaReporter(MetricRegistry registry, String host, int port, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "statsd-delta-reporter", filter, rateUnit, durationUnit);
        this.statsdClient = new StatsdClient(host, port);
        this.prefix = prefix;
    }

    public static StatsdDeltaReporterBuilder builder(String host, int port, MetricRegistry registry) {
        return StatsdDeltaReporter.hiddenBuilder().host(host).port(port).registry(registry).rateUnit(TimeUnit.SECONDS).durationUnit(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try (StatsdClient client = this.statsdClient;){
            client.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
        catch (IllegalStateException e) {
            log.error("multiple statsd connections attempted.  Possible threading issue", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("statsd service failure: {}", (Object)e.getMessage());
        }
        catch (Throwable e) {
            log.error("Unexpected error", e);
        }
    }

    private void reportTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.statsdClient.sendGauge(this.prefix(name, "max"), this.formatNumber(this.convertDuration(snapshot.getMax())));
        this.statsdClient.sendGauge(this.prefix(name, "mean"), this.formatNumber(this.convertDuration(snapshot.getMean())));
        this.statsdClient.sendGauge(this.prefix(name, "min"), this.formatNumber(this.convertDuration(snapshot.getMin())));
        this.statsdClient.sendGauge(this.prefix(name, "stddev"), this.formatNumber(this.convertDuration(snapshot.getStdDev())));
        this.statsdClient.sendGauge(this.prefix(name, "p50"), this.formatNumber(this.convertDuration(snapshot.getMedian())));
        this.statsdClient.sendGauge(this.prefix(name, "p75"), this.formatNumber(this.convertDuration(snapshot.get75thPercentile())));
        this.statsdClient.sendGauge(this.prefix(name, "p95"), this.formatNumber(this.convertDuration(snapshot.get95thPercentile())));
        this.statsdClient.sendGauge(this.prefix(name, "p98"), this.formatNumber(this.convertDuration(snapshot.get98thPercentile())));
        this.statsdClient.sendGauge(this.prefix(name, "p99"), this.formatNumber(this.convertDuration(snapshot.get99thPercentile())));
        this.statsdClient.sendGauge(this.prefix(name, "p999"), this.formatNumber(this.convertDuration(snapshot.get999thPercentile())));
        this.reportMetered(name, (Metered)timer);
    }

    private void reportMetered(String name, Metered meter) {
        this.statsdClient.sendGauge(this.prefix(name, "samples"), this.formatNumber(meter.getCount()));
        this.statsdClient.sendGauge(this.prefix(name, "m1_rate"), this.formatNumber(this.convertRate(meter.getOneMinuteRate())));
        this.statsdClient.sendGauge(this.prefix(name, "m5_rate"), this.formatNumber(this.convertRate(meter.getFiveMinuteRate())));
        this.statsdClient.sendGauge(this.prefix(name, "m15_rate"), this.formatNumber(this.convertRate(meter.getFifteenMinuteRate())));
        this.statsdClient.sendGauge(this.prefix(name, "mean_rate"), this.formatNumber(this.convertRate(meter.getMeanRate())));
    }

    private void reportHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.statsdClient.sendGauge(this.prefix(name, "samples"), this.formatNumber(histogram.getCount()));
        this.statsdClient.sendGauge(this.prefix(name, "max"), this.formatNumber(snapshot.getMax()));
        this.statsdClient.sendGauge(this.prefix(name, "mean"), this.formatNumber(snapshot.getMean()));
        this.statsdClient.sendGauge(this.prefix(name, "min"), this.formatNumber(snapshot.getMin()));
        this.statsdClient.sendGauge(this.prefix(name, "stddev"), this.formatNumber(snapshot.getStdDev()));
        this.statsdClient.sendGauge(this.prefix(name, "p50"), this.formatNumber(snapshot.getMedian()));
        this.statsdClient.sendGauge(this.prefix(name, "p75"), this.formatNumber(snapshot.get75thPercentile()));
        this.statsdClient.sendGauge(this.prefix(name, "p95"), this.formatNumber(snapshot.get95thPercentile()));
        this.statsdClient.sendGauge(this.prefix(name, "p98"), this.formatNumber(snapshot.get98thPercentile()));
        this.statsdClient.sendGauge(this.prefix(name, "p99"), this.formatNumber(snapshot.get99thPercentile()));
        this.statsdClient.sendGauge(this.prefix(name, "p999"), this.formatNumber(snapshot.get999thPercentile()));
    }

    private void reportCounter(String name, Counter counter) {
        long value = counter.getCount();
        this.statsdClient.sendCounter(name, this.formatNumber(value));
        if (this.statsdClient.success()) {
            counter.dec(value);
        }
    }

    private void reportGauge(String name, Gauge gauge) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.statsdClient.sendGauge(this.prefix(name), value);
        }
    }

    @Nullable
    private String format(Object o) {
        if (o instanceof Float) {
            return this.formatNumber(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.formatNumber((Double)o);
        }
        if (o instanceof Byte) {
            return this.formatNumber(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.formatNumber(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.formatNumber(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.formatNumber((Long)o);
        }
        if (o instanceof BigInteger) {
            return this.formatNumber((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return this.formatNumber(((BigDecimal)o).doubleValue());
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    private String formatNumber(BigInteger n) {
        return String.valueOf(n);
    }

    private String formatNumber(long n) {
        return Long.toString(n);
    }

    private String formatNumber(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static StatsdDeltaReporterBuilder hiddenBuilder() {
        return new StatsdDeltaReporterBuilder();
    }

    public static class StatsdDeltaReporterBuilder {
        private MetricRegistry registry;
        private String host;
        private int port;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        StatsdDeltaReporterBuilder() {
        }

        public StatsdDeltaReporterBuilder registry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public StatsdDeltaReporterBuilder host(String host) {
            this.host = host;
            return this;
        }

        public StatsdDeltaReporterBuilder port(int port) {
            this.port = port;
            return this;
        }

        public StatsdDeltaReporterBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public StatsdDeltaReporterBuilder rateUnit(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public StatsdDeltaReporterBuilder durationUnit(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public StatsdDeltaReporterBuilder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public StatsdDeltaReporter build() {
            return new StatsdDeltaReporter(this.registry, this.host, this.port, this.prefix, this.rateUnit, this.durationUnit, this.filter);
        }

        public String toString() {
            return "StatsdDeltaReporter.StatsdDeltaReporterBuilder(registry=" + this.registry + ", host=" + this.host + ", port=" + this.port + ", prefix=" + this.prefix + ", rateUnit=" + this.rateUnit + ", durationUnit=" + this.durationUnit + ", filter=" + this.filter + ")";
        }
    }
}

