/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3.minio;

import io.minio.MinioClient;
import org.deltafi.common.storage.s3.minio.MinioObjectStorageService;
import org.deltafi.common.storage.s3.minio.MinioProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConfigurationPropertiesScan
public class MinioAutoConfiguration {
    @Bean
    public MinioClient minioClient(MinioProperties minioProperties) {
        return MinioClient.builder().endpoint(minioProperties.getUrl()).credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioObjectStorageService minioObjectStorageService(MinioClient minioClient, MinioProperties minioProperties) {
        return new MinioObjectStorageService(minioClient, minioProperties);
    }
}

