/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;

public class ContentStorageService {
    public static final String CONTENT_BUCKET = "storage";
    private final ObjectStorageService objectStorageService;

    public InputStream load(ContentReference contentReference) throws ObjectStorageException {
        return contentReference.getSize() > 0L ? this.objectStorageService.getObject(this.buildObjectReference(contentReference)) : InputStream.nullInputStream();
    }

    public ContentReference save(String did, byte[] content, String mediaType) throws ObjectStorageException {
        if (content.length == 0) {
            return new ContentReference(UUID.randomUUID().toString(), 0L, 0L, did, mediaType);
        }
        return this.save(did, new ByteArrayInputStream(content), mediaType);
    }

    public ContentReference save(String did, InputStream inputStream, String mediaType) throws ObjectStorageException {
        ContentReference contentReference = new ContentReference(UUID.randomUUID().toString(), did, mediaType);
        ObjectReference objectReference = this.objectStorageService.putObject(this.buildObjectReference(contentReference), inputStream);
        contentReference.setSize(objectReference.getSize());
        return contentReference;
    }

    public void delete(ContentReference contentReference) {
        this.objectStorageService.removeObject(this.buildObjectReference(contentReference));
    }

    public void deleteAll(List<ContentReference> contentReferences) {
        if (!contentReferences.isEmpty()) {
            this.objectStorageService.removeObjects(CONTENT_BUCKET, contentReferences.stream().map(ContentReference::objectName).distinct().collect(Collectors.toList()));
        }
    }

    private ObjectReference buildObjectReference(ContentReference contentReference) {
        return new ObjectReference(CONTENT_BUCKET, contentReference.getDid() + "/" + contentReference.getUuid(), contentReference.getOffset(), contentReference.getSize());
    }

    public ContentStorageService(ObjectStorageService objectStorageService) {
        this.objectStorageService = objectStorageService;
    }
}

