/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.deltafi.common.ssl.SslProperties;

public class SslContextFactory {
    public static SSLContext buildSslContext(SslProperties sslProperties) throws SslException {
        try {
            SSLContext context = SSLContext.getInstance(sslProperties.getProtocol());
            context.init(SslContextFactory.keyManagers(sslProperties), SslContextFactory.trustManagers(sslProperties), SecureRandom.getInstanceStrong());
            return context;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SslException(e);
        }
    }

    private static KeyManager[] keyManagers(SslProperties sslProperties) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = SslContextFactory.loadKeyStore(sslProperties.getKeyStore(), sslProperties.getKeyStoreType(), sslProperties.getKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, sslProperties.getKeyStorePassword().toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] trustManagers(SslProperties sslProperties) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore trustStore = SslContextFactory.loadKeyStore(sslProperties.getTrustStore(), sslProperties.getTrustStoreType(), sslProperties.getTrustStorePassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyStore loadKeyStore(String keyStoreFile, String keyStoreType, String keyStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream keyStoreInputStream = new FileInputStream(keyStoreFile);){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static class SslException
    extends Exception {
        public SslException(Throwable cause) {
            super(cause);
        }
    }
}

