/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3;

public class ObjectReference {
    public static final long UNKNOWN_SIZE = -1L;
    private String bucket;
    private String name;
    private long offset;
    private long size;

    public ObjectReference(String bucket, String name) {
        this(bucket, name, 0L, -1L);
    }

    public static ObjectReferenceBuilder builder() {
        return new ObjectReferenceBuilder();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectReference)) {
            return false;
        }
        ObjectReference other = (ObjectReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObjectReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ObjectReference(bucket=" + this.getBucket() + ", name=" + this.getName() + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ")";
    }

    public ObjectReference() {
    }

    public ObjectReference(String bucket, String name, long offset, long size) {
        this.bucket = bucket;
        this.name = name;
        this.offset = offset;
        this.size = size;
    }

    public static class ObjectReferenceBuilder {
        private String bucket;
        private String name;
        private long offset;
        private long size;

        ObjectReferenceBuilder() {
        }

        public ObjectReferenceBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public ObjectReferenceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ObjectReferenceBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public ObjectReferenceBuilder size(long size) {
            this.size = size;
            return this;
        }

        public ObjectReference build() {
            return new ObjectReference(this.bucket, this.name, this.offset, this.size);
        }

        public String toString() {
            return "ObjectReference.ObjectReferenceBuilder(bucket=" + this.bucket + ", name=" + this.name + ", offset=" + this.offset + ", size=" + this.size + ")";
        }
    }
}

