/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.deltafi.common.converters.KeyValueConverter;
import org.deltafi.common.types.KeyValue;
import org.jetbrains.annotations.NotNull;

public class SourceInfo {
    private String filename;
    private String flow;
    private List<KeyValue> metadata;

    @JsonIgnore
    public Map<String, String> getMetadataAsMap() {
        return KeyValueConverter.convertKeyValues(this.metadata);
    }

    @JsonIgnore
    public boolean containsKey(String key) {
        return this.metadata.stream().anyMatch(kv -> kv.getKey().equals(key));
    }

    @JsonIgnore
    public String getMetadata(String key) {
        return this.getMetadata(key, null);
    }

    @JsonIgnore
    public String getMetadata(String key, String defaultValue) {
        return this.metadata.stream().filter(k -> k.getKey().equals(key)).findFirst().map(KeyValue::getValue).orElse(defaultValue);
    }

    public void addMetadata(KeyValue keyValue) {
        Optional<KeyValue> existing = this.metadata.stream().filter(kv -> kv.getKey().equals(keyValue.getKey())).findFirst();
        if (existing.isPresent()) {
            existing.get().setValue(keyValue.getValue());
        } else {
            this.metadata.add(keyValue);
        }
    }

    public void addMetadata(List<KeyValue> keyValues) {
        if (keyValues == null) {
            return;
        }
        for (KeyValue keyValue : keyValues) {
            this.addMetadata(keyValue);
        }
    }

    public void addMetadata(String key, String value) {
        this.addMetadata(new KeyValue(key, value));
    }

    public void addMetadata(@NotNull Map<String, String> map) {
        map.forEach(this::addMetadata);
    }

    public void removeMetadata(String key) {
        this.metadata.removeIf(kv -> kv.getKey().equals(key));
    }

    private static List<KeyValue> $default$metadata() {
        return new ArrayList<KeyValue>();
    }

    public static SourceInfoBuilder builder() {
        return new SourceInfoBuilder();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFlow() {
        return this.flow;
    }

    public List<KeyValue> getMetadata() {
        return this.metadata;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setMetadata(List<KeyValue> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceInfo)) {
            return false;
        }
        SourceInfo other = (SourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        List<KeyValue> this$metadata = this.getMetadata();
        List<KeyValue> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        List<KeyValue> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "SourceInfo(filename=" + this.getFilename() + ", flow=" + this.getFlow() + ", metadata=" + this.getMetadata() + ")";
    }

    public SourceInfo() {
        this.metadata = SourceInfo.$default$metadata();
    }

    public SourceInfo(String filename, String flow, List<KeyValue> metadata) {
        this.filename = filename;
        this.flow = flow;
        this.metadata = metadata;
    }

    public static class SourceInfoBuilder {
        private String filename;
        private String flow;
        private boolean metadata$set;
        private List<KeyValue> metadata$value;

        SourceInfoBuilder() {
        }

        public SourceInfoBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public SourceInfoBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public SourceInfoBuilder metadata(List<KeyValue> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        public SourceInfo build() {
            List<KeyValue> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = SourceInfo.$default$metadata();
            }
            return new SourceInfo(this.filename, this.flow, metadata$value);
        }

        public String toString() {
            return "SourceInfo.SourceInfoBuilder(filename=" + this.filename + ", flow=" + this.flow + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

