/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.http;

import java.net.http.HttpClient;
import org.deltafi.common.http.HttpService;
import org.deltafi.common.ssl.SslContextFactory;
import org.deltafi.common.ssl.SslProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties
public class HttpServiceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HttpServiceAutoConfiguration.class);

    @Bean
    @ConfigurationProperties(value="ssl")
    public SslProperties sslProperties() {
        return new SslProperties();
    }

    @Bean
    public HttpClient httpClient(SslProperties sslProperties) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (this.isConfigured(sslProperties)) {
            try {
                httpClientBuilder.sslContext(SslContextFactory.buildSslContext(sslProperties));
            }
            catch (SslContextFactory.SslException e) {
                log.error("Unable to build SSL context. SSL will be disabled.", (Throwable)e);
            }
        }
        return httpClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpService httpService(HttpClient httpClient) {
        return new HttpService(httpClient);
    }

    private boolean isConfigured(SslProperties sslProperties) {
        if (null == sslProperties || this.isPasswordNotSet(sslProperties.getKeyStorePassword())) {
            log.info("SSL Configuration is not setup, SSL will not be enabled");
            return false;
        }
        log.info("Configuring SSL with keystore {} and truststore {}", (Object)sslProperties.getKeyStore(), (Object)sslProperties.getTrustStore());
        return true;
    }

    private boolean isPasswordNotSet(String password) {
        return null != password && "not-set".equals(password);
    }
}

