/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.deltafi.common.content.ContentReference;
import org.deltafi.common.content.Segment;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;
import org.deltafi.common.types.Content;

public class ContentStorageService {
    public static final String CONTENT_BUCKET = "storage";
    private final ObjectStorageService objectStorageService;

    public InputStream load(ContentReference contentReference) throws ObjectStorageException {
        if (contentReference.getSize() > 0L) {
            if (contentReference.getSegments().size() == 1) {
                return this.objectStorageService.getObject(this.buildObjectReference(contentReference.getSegments().get(0)));
            }
            try {
                return new SequenceInputStream(Collections.enumeration(contentReference.getSegments().stream().map(s -> {
                    try {
                        return this.objectStorageService.getObject(this.buildObjectReference((Segment)s));
                    }
                    catch (ObjectStorageException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList())));
            }
            catch (RuntimeException e) {
                throw new ObjectStorageException(e);
            }
        }
        return InputStream.nullInputStream();
    }

    public ContentReference save(String did, byte[] content, String mediaType) throws ObjectStorageException {
        if (content.length == 0) {
            return new ContentReference(mediaType, new Segment[0]);
        }
        return this.save(did, new ByteArrayInputStream(content), mediaType);
    }

    public List<Content> saveMany(String did, Map<Content, byte[]> contentToBytes) throws ObjectStorageException {
        ArrayList<Content> updatedContent = new ArrayList<Content>();
        LinkedHashMap<ObjectReference, InputStream> objectsToSave = new LinkedHashMap<ObjectReference, InputStream>();
        for (Map.Entry<Content, byte[]> inputStreamEntry : contentToBytes.entrySet()) {
            Content content = inputStreamEntry.getKey();
            byte[] entryBytes = inputStreamEntry.getValue();
            if (entryBytes.length == 0) {
                content.setContentReference(new ContentReference("application/octet-stream", new Segment[0]));
                updatedContent.add(content);
                continue;
            }
            Segment segment = new Segment(did);
            segment.setSize(entryBytes.length);
            content.setContentReference(new ContentReference("application/octet-stream", segment));
            objectsToSave.put(this.buildObjectReference(segment), new ByteArrayInputStream(entryBytes));
            updatedContent.add(content);
        }
        this.objectStorageService.putObjects(CONTENT_BUCKET, objectsToSave);
        return updatedContent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentReference save(String did, InputStream inputStream, String mediaType) throws ObjectStorageException {
        Segment segment = new Segment(did);
        try (PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);){
            int byTe = pushbackInputStream.read();
            if (byTe == -1) {
                ContentReference contentReference = new ContentReference(mediaType, new Segment[0]);
                return contentReference;
            }
            pushbackInputStream.unread(byTe);
            ObjectReference objectReference = this.objectStorageService.putObject(this.buildObjectReference(segment), pushbackInputStream);
            segment.setSize(objectReference.getSize());
            ContentReference contentReference = new ContentReference(mediaType, segment);
            return contentReference;
        }
        catch (IOException e) {
            throw new ObjectStorageException("Error saving content " + segment.objectName(), e);
        }
    }

    public void delete(ContentReference contentReference) {
        if (contentReference.getSegments().size() == 1) {
            this.objectStorageService.removeObject(this.buildObjectReference(contentReference.getSegments().get(0)));
        } else {
            this.deleteAll(contentReference.getSegments());
        }
    }

    public void deleteAll(List<Segment> segments) {
        if (!segments.isEmpty()) {
            this.objectStorageService.removeObjects(CONTENT_BUCKET, segments.stream().map(Segment::objectName).distinct().collect(Collectors.toList()));
        }
    }

    private ObjectReference buildObjectReference(Segment segment) {
        return new ObjectReference(CONTENT_BUCKET, segment.objectName(), segment.getOffset(), segment.getSize());
    }

    public ContentStorageService(ObjectStorageService objectStorageService) {
        this.objectStorageService = objectStorageService;
    }
}

