/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Metric {
    private final String name;
    private final long value;
    private final Map<String, String> tags = new HashMap<String, String>();

    public String metricName() {
        String taglist = this.tags.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(t -> (String)t.getKey() + "=" + (String)t.getValue()).collect(Collectors.joining(";"));
        if (taglist.isBlank()) {
            return this.name;
        }
        return String.join((CharSequence)";", this.name, taglist);
    }

    public Metric addTags(Map<String, String> tags) {
        this.tags.putAll(tags);
        return this;
    }

    public Metric addTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Metric(name=" + this.getName() + ", value=" + this.getValue() + ", tags=" + this.getTags() + ")";
    }

    public Metric(String name, long value) {
        this.name = name;
        this.value = value;
    }
}

