/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3.minio;

import io.minio.BucketExistsArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.GetObjectArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.SetBucketLifecycleArgs;
import io.minio.SnowballObject;
import io.minio.UploadSnowballObjectsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Expiration;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.LifecycleRule;
import io.minio.messages.RuleFilter;
import io.minio.messages.Status;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.input.CountingInputStream;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;
import org.deltafi.common.storage.s3.minio.MinioProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioObjectStorageService
implements ObjectStorageService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectStorageService.class);
    private static final String AGE_OFF = "AgeOff";
    protected final MinioClient minioClient;
    protected final MinioProperties minioProperties;

    @Override
    public boolean bucketExists(String bucketName) throws ObjectStorageException {
        try {
            return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            log.error("Unable to check bucket existence");
            throw new ObjectStorageException("Unable to check bucket existence", e);
        }
    }

    @Override
    public void createBucket(String bucketName) throws ObjectStorageException {
        if (!this.bucketExists(bucketName)) {
            try {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
                log.info("Created the bucket: " + bucketName);
            }
            catch (Exception e) {
                log.error("Unable to create bucket");
                throw new ObjectStorageException("Unable to create bucket", e);
            }
        }
    }

    @Override
    public boolean expectedConfiguration(String bucketName) throws ObjectStorageException {
        try {
            return this.checkConfiguration(this.minioClient.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketName)).build()));
        }
        catch (Exception e) {
            log.error("Unable to get bucket lifecycle");
            throw new ObjectStorageException("Unable to get bucket lifecycle", e);
        }
    }

    private boolean checkConfiguration(LifecycleConfiguration configuration) {
        return configuration != null && configuration.rules() != null && configuration.rules().size() == 1 && ((LifecycleRule)configuration.rules().get(0)).status() == Status.ENABLED && ((LifecycleRule)configuration.rules().get(0)).id().equals(AGE_OFF) && ((LifecycleRule)configuration.rules().get(0)).expiration().days().intValue() == this.minioProperties.getExpirationDays();
    }

    @Override
    public void setExpiration(String bucketName) throws ObjectStorageException {
        try {
            this.minioClient.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).config(this.getLifeCycleConfig()).build());
            log.info("Set bucket age-off days: " + this.minioProperties.getExpirationDays());
        }
        catch (Exception e) {
            log.error("Unable to set bucket lifecycle");
            throw new ObjectStorageException("Unable to set bucket lifecycle", e);
        }
    }

    private LifecycleConfiguration getLifeCycleConfig() {
        return new LifecycleConfiguration(List.of(new LifecycleRule(Status.ENABLED, null, new Expiration((ZonedDateTime)null, Integer.valueOf(this.minioProperties.getExpirationDays()), null), new RuleFilter(""), AGE_OFF, null, null, null)));
    }

    @Override
    public InputStream getObject(ObjectReference objectReference) throws ObjectStorageException {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).offset(Long.valueOf(objectReference.getOffset()))).length(Long.valueOf(objectReference.getSize()))).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ObjectStorageException("Failed to get object from minio", e);
        }
    }

    @Override
    public ObjectReference putObject(ObjectReference objectReference, InputStream inputStream) throws ObjectStorageException {
        try {
            ObjectReference objectReference2;
            CountingInputStream countingInputStream = new CountingInputStream(inputStream);
            try {
                ObjectWriteResponse objectWriteResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).stream((InputStream)countingInputStream, objectReference.getSize(), this.minioProperties.getPartSize()).build());
                objectReference2 = new ObjectReference(objectWriteResponse.bucket(), objectWriteResponse.object(), 0L, countingInputStream.getByteCount());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        countingInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                    log.error("Failed to save incoming object", e);
                    throw new ObjectStorageException("Failed to send incoming data to minio", e);
                }
            }
            countingInputStream.close();
            return objectReference2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close input stream: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void putObjects(String bucket, Map<ObjectReference, InputStream> inputStreamMap) throws ObjectStorageException {
        try {
            this.minioClient.uploadSnowballObjects((UploadSnowballObjectsArgs)((UploadSnowballObjectsArgs.Builder)UploadSnowballObjectsArgs.builder().bucket(bucket)).objects((Iterable)inputStreamMap.entrySet().stream().map(this::createSnowballObject).collect(Collectors.toList())).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to save incoming object", e);
            throw new ObjectStorageException("Failed to send incoming data to minio", e);
        }
    }

    private SnowballObject createSnowballObject(Map.Entry<ObjectReference, InputStream> objectReferenceInputStreamEntry) {
        ObjectReference objectReference = objectReferenceInputStreamEntry.getKey();
        return new SnowballObject(objectReference.getName(), objectReferenceInputStreamEntry.getValue(), objectReference.getSize(), null);
    }

    @Override
    public void removeObject(ObjectReference objectReference) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to remove object {} from bucket {}", (Object)objectReference.getName(), (Object)objectReference.getBucket());
        }
    }

    @Override
    public boolean removeObjects(String bucket, List<String> objectNames) {
        List objectsInStorage = objectNames.stream().map(DeleteObject::new).collect(Collectors.toList());
        log.info("Sending command to delete " + objectsInStorage.size() + " objects in storage from minio");
        Iterable removeResults = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(objectsInStorage).build());
        boolean hasError = false;
        for (Result removeResult : removeResults) {
            hasError = true;
            try {
                DeleteError error = (DeleteError)removeResult.get();
                log.error("Failed to remove object {} with an error of {}", (Object)error.objectName(), (Object)error.message());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("Failed to remove object: {}", (Object)e.getMessage());
            }
        }
        return !hasError;
    }

    public MinioObjectStorageService(MinioClient minioClient, MinioProperties minioProperties) {
        this.minioClient = minioClient;
        this.minioProperties = minioProperties;
    }
}

